/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.UserSchedule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Information to create a schedule for a week in management unit using imported data")
public class ImportWeekScheduleRequest
implements Serializable {
    private String description = null;
    private Map<String, UserSchedule> userSchedules = null;
    private Boolean published = null;
    private String shortTermForecastId = null;
    private List<String> partialUploadIds = new ArrayList<String>();

    public ImportWeekScheduleRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Description for the schedule")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImportWeekScheduleRequest userSchedules(Map<String, UserSchedule> userSchedules) {
        this.userSchedules = userSchedules;
        return this;
    }

    @ApiModelProperty(example="null", value="User schedules")
    @JsonProperty(value="userSchedules")
    public Map<String, UserSchedule> getUserSchedules() {
        return this.userSchedules;
    }

    public void setUserSchedules(Map<String, UserSchedule> userSchedules) {
        this.userSchedules = userSchedules;
    }

    public ImportWeekScheduleRequest published(Boolean published) {
        this.published = published;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the schedule is published")
    @JsonProperty(value="published")
    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public ImportWeekScheduleRequest shortTermForecastId(String shortTermForecastId) {
        this.shortTermForecastId = shortTermForecastId;
        return this;
    }

    @ApiModelProperty(example="null", value="Short term forecast that should be associated with this schedule")
    @JsonProperty(value="shortTermForecastId")
    public String getShortTermForecastId() {
        return this.shortTermForecastId;
    }

    public void setShortTermForecastId(String shortTermForecastId) {
        this.shortTermForecastId = shortTermForecastId;
    }

    public ImportWeekScheduleRequest partialUploadIds(List<String> partialUploadIds) {
        this.partialUploadIds = partialUploadIds;
        return this;
    }

    @ApiModelProperty(example="null", value="IDs of partial uploads of user schedules to import week schedule. It is applicable only for large schedules where activity count in schedule is greater than 17500")
    @JsonProperty(value="partialUploadIds")
    public List<String> getPartialUploadIds() {
        return this.partialUploadIds;
    }

    public void setPartialUploadIds(List<String> partialUploadIds) {
        this.partialUploadIds = partialUploadIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportWeekScheduleRequest importWeekScheduleRequest = (ImportWeekScheduleRequest)o;
        return Objects.equals(this.description, importWeekScheduleRequest.description) && Objects.equals(this.userSchedules, importWeekScheduleRequest.userSchedules) && Objects.equals(this.published, importWeekScheduleRequest.published) && Objects.equals(this.shortTermForecastId, importWeekScheduleRequest.shortTermForecastId) && Objects.equals(this.partialUploadIds, importWeekScheduleRequest.partialUploadIds);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.userSchedules, this.published, this.shortTermForecastId, this.partialUploadIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportWeekScheduleRequest {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    userSchedules: ").append(this.toIndentedString(this.userSchedules)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    shortTermForecastId: ").append(this.toIndentedString(this.shortTermForecastId)).append("\n");
        sb.append("    partialUploadIds: ").append(this.toIndentedString(this.partialUploadIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

