/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ImportStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class DncList
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private ImportStatus importStatus = null;
    private Long size = null;
    private DncSourceTypeEnum dncSourceType = null;
    private String loginId = null;
    private List<String> dncCodes = new ArrayList<String>();
    private String licenseId = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DncList name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the DncList.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public DncList version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DncList importStatus(ImportStatus importStatus) {
        this.importStatus = importStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the import process")
    @JsonProperty(value="importStatus")
    public ImportStatus getImportStatus() {
        return this.importStatus;
    }

    public void setImportStatus(ImportStatus importStatus) {
        this.importStatus = importStatus;
    }

    @ApiModelProperty(example="null", value="The total number of phone numbers in the DncList.")
    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    public DncList dncSourceType(DncSourceTypeEnum dncSourceType) {
        this.dncSourceType = dncSourceType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the DncList.")
    @JsonProperty(value="dncSourceType")
    public DncSourceTypeEnum getDncSourceType() {
        return this.dncSourceType;
    }

    public void setDncSourceType(DncSourceTypeEnum dncSourceType) {
        this.dncSourceType = dncSourceType;
    }

    public DncList loginId(String loginId) {
        this.loginId = loginId;
        return this;
    }

    @ApiModelProperty(example="null", value="A dnc.com loginId. Required if the dncSourceType is dnc.com.")
    @JsonProperty(value="loginId")
    public String getLoginId() {
        return this.loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public DncList dncCodes(List<String> dncCodes) {
        this.dncCodes = dncCodes;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of dnc.com codes to be treated as DNC. Required if the dncSourceType is dnc.com.")
    @JsonProperty(value="dncCodes")
    public List<String> getDncCodes() {
        return this.dncCodes;
    }

    public void setDncCodes(List<String> dncCodes) {
        this.dncCodes = dncCodes;
    }

    public DncList licenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    @ApiModelProperty(example="null", value="A gryphon license number. Required if the dncSourceType is gryphon.")
    @JsonProperty(value="licenseId")
    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DncList dncList = (DncList)o;
        return Objects.equals(this.id, dncList.id) && Objects.equals(this.name, dncList.name) && Objects.equals(this.dateCreated, dncList.dateCreated) && Objects.equals(this.dateModified, dncList.dateModified) && Objects.equals(this.version, dncList.version) && Objects.equals(this.importStatus, dncList.importStatus) && Objects.equals(this.size, dncList.size) && Objects.equals((Object)this.dncSourceType, (Object)dncList.dncSourceType) && Objects.equals(this.loginId, dncList.loginId) && Objects.equals(this.dncCodes, dncList.dncCodes) && Objects.equals(this.licenseId, dncList.licenseId) && Objects.equals(this.selfUri, dncList.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.dateModified, this.version, this.importStatus, this.size, this.dncSourceType, this.loginId, this.dncCodes, this.licenseId, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DncList {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    importStatus: ").append(this.toIndentedString(this.importStatus)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    dncSourceType: ").append(this.toIndentedString((Object)this.dncSourceType)).append("\n");
        sb.append("    loginId: ").append(this.toIndentedString(this.loginId)).append("\n");
        sb.append("    dncCodes: ").append(this.toIndentedString(this.dncCodes)).append("\n");
        sb.append("    licenseId: ").append(this.toIndentedString(this.licenseId)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DncSourceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RDS("rds"),
        DNC_COM("dnc.com"),
        GRYPHON("gryphon");

        private String value;

        private DncSourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DncSourceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DncSourceTypeEnum value : DncSourceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DncSourceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

