/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetFlowsDatatableRequest {
    private String datatableId;
    private String expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDatatableId() {
        return this.datatableId;
    }

    public void setDatatableId(String datatableId) {
        this.datatableId = datatableId;
    }

    public GetFlowsDatatableRequest withDatatableId(String datatableId) {
        this.setDatatableId(datatableId);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public GetFlowsDatatableRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetFlowsDatatableRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.datatableId == null) {
            throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for GetFlowsDatatableRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/flows/datatables/{datatableId}").withPathParameter("datatableId", this.datatableId).withQueryParameters("expand", "", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String datatableId) {
        return new Builder().withRequiredParams(datatableId);
    }

    public static class Builder {
        private final GetFlowsDatatableRequest request = new GetFlowsDatatableRequest();

        private Builder() {
        }

        public Builder withDatatableId(String datatableId) {
            this.request.setDatatableId(datatableId);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpand(expandValues expand) {
            this.request.setExpand(expand.toString());
            return this;
        }

        public Builder withRequiredParams(String datatableId) {
            this.request.setDatatableId(datatableId);
            return this;
        }

        public GetFlowsDatatableRequest build() {
            if (this.request.datatableId == null) {
                throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for GetFlowsDatatableRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        SCHEMA("schema");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

