/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class PostFlowVersionsRequest {
    private String flowId;
    private Object body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public PostFlowVersionsRequest withFlowId(String flowId) {
        this.setFlowId(flowId);
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public PostFlowVersionsRequest withBody(Object body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostFlowVersionsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Object> withHttpInfo() {
        if (this.flowId == null) {
            throw new IllegalStateException("Missing the required parameter 'flowId' when building request for PostFlowVersionsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostFlowVersionsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/flows/{flowId}/versions").withPathParameter("flowId", this.flowId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String flowId, Object body) {
        return new Builder().withRequiredParams(flowId, body);
    }

    public static class Builder {
        private final PostFlowVersionsRequest request = new PostFlowVersionsRequest();

        private Builder() {
        }

        public Builder withFlowId(String flowId) {
            this.request.setFlowId(flowId);
            return this;
        }

        public Builder withBody(Object body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String flowId, Object body) {
            this.request.setFlowId(flowId);
            this.request.setBody(body);
            return this;
        }

        public PostFlowVersionsRequest build() {
            if (this.request.flowId == null) {
                throw new IllegalStateException("Missing the required parameter 'flowId' when building request for PostFlowVersionsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostFlowVersionsRequest.");
            }
            return this.request;
        }
    }
}

