/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.MediaParticipantRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchConversationsEmailParticipantCommunicationRequest {
    private String conversationId;
    private String participantId;
    private String communicationId;
    private MediaParticipantRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PatchConversationsEmailParticipantCommunicationRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PatchConversationsEmailParticipantCommunicationRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public PatchConversationsEmailParticipantCommunicationRequest withCommunicationId(String communicationId) {
        this.setCommunicationId(communicationId);
        return this;
    }

    public MediaParticipantRequest getBody() {
        return this.body;
    }

    public void setBody(MediaParticipantRequest body) {
        this.body = body;
    }

    public PatchConversationsEmailParticipantCommunicationRequest withBody(MediaParticipantRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsEmailParticipantCommunicationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<MediaParticipantRequest> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PatchConversationsEmailParticipantCommunicationRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsEmailParticipantCommunicationRequest.");
        }
        if (this.communicationId == null) {
            throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PatchConversationsEmailParticipantCommunicationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsEmailParticipantCommunicationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/emails/{conversationId}/participants/{participantId}/communications/{communicationId}").withPathParameter("conversationId", this.conversationId).withPathParameter("participantId", this.participantId).withPathParameter("communicationId", this.communicationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String participantId, String communicationId, MediaParticipantRequest body) {
        return new Builder().withRequiredParams(conversationId, participantId, communicationId, body);
    }

    public static class Builder {
        private final PatchConversationsEmailParticipantCommunicationRequest request = new PatchConversationsEmailParticipantCommunicationRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withCommunicationId(String communicationId) {
            this.request.setCommunicationId(communicationId);
            return this;
        }

        public Builder withBody(MediaParticipantRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String participantId, String communicationId, MediaParticipantRequest body) {
            this.request.setConversationId(conversationId);
            this.request.setParticipantId(participantId);
            this.request.setCommunicationId(communicationId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsEmailParticipantCommunicationRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PatchConversationsEmailParticipantCommunicationRequest.");
            }
            if (this.request.participantId == null) {
                throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsEmailParticipantCommunicationRequest.");
            }
            if (this.request.communicationId == null) {
                throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PatchConversationsEmailParticipantCommunicationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsEmailParticipantCommunicationRequest.");
            }
            return this.request;
        }
    }
}

