/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.IntradayDataGroup;
import com.mypurecloud.sdk.v2.model.IntradayMetric;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class IntradayResponse
implements Serializable {
    private Date startDate = null;
    private Date endDate = null;
    private Integer intervalLengthMinutes = null;
    private Integer numberOfIntervals = null;
    private List<IntradayMetric> metrics = new ArrayList<IntradayMetric>();
    private NoDataReasonEnum noDataReason = null;
    private List<String> queueIds = new ArrayList<String>();
    private List<IntradayDataGroup> intradayDataGroupings = new ArrayList<IntradayDataGroup>();

    public IntradayResponse startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start of the date range for which this data applies.  This is also the start reference point for the intervals represented in the various arrays. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public IntradayResponse endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The end of the date range for which this data applies. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public IntradayResponse intervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The aggregation period in minutes, which determines the interval duration of the returned data")
    @JsonProperty(value="intervalLengthMinutes")
    public Integer getIntervalLengthMinutes() {
        return this.intervalLengthMinutes;
    }

    public void setIntervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
    }

    public IntradayResponse numberOfIntervals(Integer numberOfIntervals) {
        this.numberOfIntervals = numberOfIntervals;
        return this;
    }

    @ApiModelProperty(example="null", value="The total number of time intervals represented by this data")
    @JsonProperty(value="numberOfIntervals")
    public Integer getNumberOfIntervals() {
        return this.numberOfIntervals;
    }

    public void setNumberOfIntervals(Integer numberOfIntervals) {
        this.numberOfIntervals = numberOfIntervals;
    }

    public IntradayResponse metrics(List<IntradayMetric> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="The metrics to which this data corresponds")
    @JsonProperty(value="metrics")
    public List<IntradayMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<IntradayMetric> metrics) {
        this.metrics = metrics;
    }

    public IntradayResponse noDataReason(NoDataReasonEnum noDataReason) {
        this.noDataReason = noDataReason;
        return this;
    }

    @ApiModelProperty(example="null", value="If not null, the reason there was no data for the request")
    @JsonProperty(value="noDataReason")
    public NoDataReasonEnum getNoDataReason() {
        return this.noDataReason;
    }

    public void setNoDataReason(NoDataReasonEnum noDataReason) {
        this.noDataReason = noDataReason;
    }

    public IntradayResponse queueIds(List<String> queueIds) {
        this.queueIds = queueIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of the queues this data corresponds to")
    @JsonProperty(value="queueIds")
    public List<String> getQueueIds() {
        return this.queueIds;
    }

    public void setQueueIds(List<String> queueIds) {
        this.queueIds = queueIds;
    }

    public IntradayResponse intradayDataGroupings(List<IntradayDataGroup> intradayDataGroupings) {
        this.intradayDataGroupings = intradayDataGroupings;
        return this;
    }

    @ApiModelProperty(example="null", value="Intraday data grouped by a single media type and set of queue IDs")
    @JsonProperty(value="intradayDataGroupings")
    public List<IntradayDataGroup> getIntradayDataGroupings() {
        return this.intradayDataGroupings;
    }

    public void setIntradayDataGroupings(List<IntradayDataGroup> intradayDataGroupings) {
        this.intradayDataGroupings = intradayDataGroupings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntradayResponse intradayResponse = (IntradayResponse)o;
        return Objects.equals(this.startDate, intradayResponse.startDate) && Objects.equals(this.endDate, intradayResponse.endDate) && Objects.equals(this.intervalLengthMinutes, intradayResponse.intervalLengthMinutes) && Objects.equals(this.numberOfIntervals, intradayResponse.numberOfIntervals) && Objects.equals(this.metrics, intradayResponse.metrics) && Objects.equals((Object)this.noDataReason, (Object)intradayResponse.noDataReason) && Objects.equals(this.queueIds, intradayResponse.queueIds) && Objects.equals(this.intradayDataGroupings, intradayResponse.intradayDataGroupings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startDate, this.endDate, this.intervalLengthMinutes, this.numberOfIntervals, this.metrics, this.noDataReason, this.queueIds, this.intradayDataGroupings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntradayResponse {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    intervalLengthMinutes: ").append(this.toIndentedString(this.intervalLengthMinutes)).append("\n");
        sb.append("    numberOfIntervals: ").append(this.toIndentedString(this.numberOfIntervals)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    noDataReason: ").append(this.toIndentedString((Object)this.noDataReason)).append("\n");
        sb.append("    queueIds: ").append(this.toIndentedString(this.queueIds)).append("\n");
        sb.append("    intradayDataGroupings: ").append(this.toIndentedString(this.intradayDataGroupings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NoDataReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOWEEKDATA("NoWeekData"),
        NOPUBLISHEDSCHEDULE("NoPublishedSchedule"),
        NOSOURCEFORECAST("NoSourceForecast");

        private String value;

        private NoDataReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NoDataReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NoDataReasonEnum value : NoDataReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NoDataReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

