/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Conversation;
import java.util.HashMap;
import java.util.Map;

public class PatchConversationsEmailRequest {
    private String emailId;
    private Conversation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public PatchConversationsEmailRequest withEmailId(String emailId) {
        this.setEmailId(emailId);
        return this;
    }

    public Conversation getBody() {
        return this.body;
    }

    public void setBody(Conversation body) {
        this.body = body;
    }

    public PatchConversationsEmailRequest withBody(Conversation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsEmailRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Conversation> withHttpInfo() {
        if (this.emailId == null) {
            throw new IllegalStateException("Missing the required parameter 'emailId' when building request for PatchConversationsEmailRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsEmailRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/emails/{emailId}").withPathParameter("emailId", this.emailId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String emailId, Conversation body) {
        return new Builder().withRequiredParams(emailId, body);
    }

    public static class Builder {
        private final PatchConversationsEmailRequest request = new PatchConversationsEmailRequest();

        private Builder() {
        }

        public Builder withEmailId(String emailId) {
            this.request.setEmailId(emailId);
            return this;
        }

        public Builder withBody(Conversation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String emailId, Conversation body) {
            this.request.setEmailId(emailId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsEmailRequest build() {
            if (this.request.emailId == null) {
                throw new IllegalStateException("Missing the required parameter 'emailId' when building request for PatchConversationsEmailRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsEmailRequest.");
            }
            return this.request;
        }
    }
}

