/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.MediaParticipantRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchConversationsChatParticipantRequest {
    private String chatId;
    private String participantId;
    private MediaParticipantRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public PatchConversationsChatParticipantRequest withChatId(String chatId) {
        this.setChatId(chatId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PatchConversationsChatParticipantRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public MediaParticipantRequest getBody() {
        return this.body;
    }

    public void setBody(MediaParticipantRequest body) {
        this.body = body;
    }

    public PatchConversationsChatParticipantRequest withBody(MediaParticipantRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsChatParticipantRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<MediaParticipantRequest> withHttpInfo() {
        if (this.chatId == null) {
            throw new IllegalStateException("Missing the required parameter 'chatId' when building request for PatchConversationsChatParticipantRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsChatParticipantRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsChatParticipantRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/chats/{chatId}/participants/{participantId}").withPathParameter("chatId", this.chatId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String chatId, String participantId, MediaParticipantRequest body) {
        return new Builder().withRequiredParams(chatId, participantId, body);
    }

    public static class Builder {
        private final PatchConversationsChatParticipantRequest request = new PatchConversationsChatParticipantRequest();

        private Builder() {
        }

        public Builder withChatId(String chatId) {
            this.request.setChatId(chatId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(MediaParticipantRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String chatId, String participantId, MediaParticipantRequest body) {
            this.request.setChatId(chatId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsChatParticipantRequest build() {
            if (this.request.chatId == null) {
                throw new IllegalStateException("Missing the required parameter 'chatId' when building request for PatchConversationsChatParticipantRequest.");
            }
            if (this.request.participantId == null) {
                throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsChatParticipantRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsChatParticipantRequest.");
            }
            return this.request;
        }
    }
}

