/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Conversation;
import java.util.HashMap;
import java.util.Map;

public class PatchConversationsCallRequest {
    private String callId;
    private Conversation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public PatchConversationsCallRequest withCallId(String callId) {
        this.setCallId(callId);
        return this;
    }

    public Conversation getBody() {
        return this.body;
    }

    public void setBody(Conversation body) {
        this.body = body;
    }

    public PatchConversationsCallRequest withBody(Conversation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsCallRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Conversation> withHttpInfo() {
        if (this.callId == null) {
            throw new IllegalStateException("Missing the required parameter 'callId' when building request for PatchConversationsCallRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsCallRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/calls/{callId}").withPathParameter("callId", this.callId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callId, Conversation body) {
        return new Builder().withRequiredParams(callId, body);
    }

    public static class Builder {
        private final PatchConversationsCallRequest request = new PatchConversationsCallRequest();

        private Builder() {
        }

        public Builder withCallId(String callId) {
            this.request.setCallId(callId);
            return this;
        }

        public Builder withBody(Conversation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String callId, Conversation body) {
            this.request.setCallId(callId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsCallRequest build() {
            if (this.request.callId == null) {
                throw new IllegalStateException("Missing the required parameter 'callId' when building request for PatchConversationsCallRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsCallRequest.");
            }
            return this.request;
        }
    }
}

