/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Evaluation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutQualityConversationEvaluationRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String conversationId;
    private String evaluationId;
    private Evaluation body;
    private String expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PutQualityConversationEvaluationRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getEvaluationId() {
        return this.evaluationId;
    }

    public void setEvaluationId(String evaluationId) {
        this.evaluationId = evaluationId;
    }

    public PutQualityConversationEvaluationRequest withEvaluationId(String evaluationId) {
        this.setEvaluationId(evaluationId);
        return this;
    }

    public Evaluation getBody() {
        return this.body;
    }

    public void setBody(Evaluation body) {
        this.body = body;
    }

    public PutQualityConversationEvaluationRequest withBody(Evaluation body) {
        this.setBody(body);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public PutQualityConversationEvaluationRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutQualityConversationEvaluationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Evaluation> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PutQualityConversationEvaluationRequest.");
        }
        if (this.evaluationId == null) {
            throw new IllegalStateException("Missing the required parameter 'evaluationId' when building request for PutQualityConversationEvaluationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityConversationEvaluationRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}").withPathParameter("conversationId", this.conversationId).withPathParameter("evaluationId", this.evaluationId).withQueryParameters("expand", "", this.expand).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String evaluationId, Evaluation body) {
        return new Builder().withRequiredParams(conversationId, evaluationId, body);
    }

    public static class Builder {
        private final PutQualityConversationEvaluationRequest request = new PutQualityConversationEvaluationRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withEvaluationId(String evaluationId) {
            this.request.setEvaluationId(evaluationId);
            return this;
        }

        public Builder withBody(Evaluation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String evaluationId, Evaluation body) {
            this.request.setConversationId(conversationId);
            this.request.setEvaluationId(evaluationId);
            this.request.setBody(body);
            return this;
        }

        public PutQualityConversationEvaluationRequest build() {
            return this.request;
        }
    }
}

