/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Attribute;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutAttributeRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String attributeId;
    private Attribute body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(String attributeId) {
        this.attributeId = attributeId;
    }

    public PutAttributeRequest withAttributeId(String attributeId) {
        this.setAttributeId(attributeId);
        return this;
    }

    public Attribute getBody() {
        return this.body;
    }

    public void setBody(Attribute body) {
        this.body = body;
    }

    public PutAttributeRequest withBody(Attribute body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutAttributeRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Attribute> withHttpInfo() {
        if (this.attributeId == null) {
            throw new IllegalStateException("Missing the required parameter 'attributeId' when building request for PutAttributeRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAttributeRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/attributes/{attributeId}").withPathParameter("attributeId", this.attributeId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String attributeId, Attribute body) {
        return new Builder().withRequiredParams(attributeId, body);
    }

    public static class Builder {
        private final PutAttributeRequest request = new PutAttributeRequest();

        private Builder() {
        }

        public Builder withAttributeId(String attributeId) {
            this.request.setAttributeId(attributeId);
            return this;
        }

        public Builder withBody(Attribute body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String attributeId, Attribute body) {
            this.request.setAttributeId(attributeId);
            this.request.setBody(body);
            return this;
        }

        public PutAttributeRequest build() {
            return this.request;
        }
    }
}

