/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ParticipantAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchConversationsChatParticipantAttributesRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String chatId;
    private String participantId;
    private ParticipantAttributes body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public PatchConversationsChatParticipantAttributesRequest withChatId(String chatId) {
        this.setChatId(chatId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PatchConversationsChatParticipantAttributesRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public ParticipantAttributes getBody() {
        return this.body;
    }

    public void setBody(ParticipantAttributes body) {
        this.body = body;
    }

    public PatchConversationsChatParticipantAttributesRequest withBody(ParticipantAttributes body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsChatParticipantAttributesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ParticipantAttributes> withHttpInfo() {
        if (this.chatId == null) {
            throw new IllegalStateException("Missing the required parameter 'chatId' when building request for PatchConversationsChatParticipantAttributesRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsChatParticipantAttributesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsChatParticipantAttributesRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes").withPathParameter("chatId", this.chatId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String chatId, String participantId, ParticipantAttributes body) {
        return new Builder().withRequiredParams(chatId, participantId, body);
    }

    public static class Builder {
        private final PatchConversationsChatParticipantAttributesRequest request = new PatchConversationsChatParticipantAttributesRequest();

        private Builder() {
        }

        public Builder withChatId(String chatId) {
            this.request.setChatId(chatId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(ParticipantAttributes body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String chatId, String participantId, ParticipantAttributes body) {
            this.request.setChatId(chatId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsChatParticipantAttributesRequest build() {
            return this.request;
        }
    }
}

