/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetRoutingLanguageRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String languageId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public GetRoutingLanguageRequest withLanguageId(String languageId) {
        this.setLanguageId(languageId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetRoutingLanguageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.languageId == null) {
            throw new IllegalStateException("Missing the required parameter 'languageId' when building request for GetRoutingLanguageRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/routing/languages/{languageId}").withPathParameter("languageId", this.languageId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String languageId) {
        return new Builder().withRequiredParams(languageId);
    }

    public static class Builder {
        private final GetRoutingLanguageRequest request = new GetRoutingLanguageRequest();

        private Builder() {
        }

        public Builder withLanguageId(String languageId) {
            this.request.setLanguageId(languageId);
            return this;
        }

        public Builder withRequiredParams(String languageId) {
            this.request.setLanguageId(languageId);
            return this;
        }

        public GetRoutingLanguageRequest build() {
            return this.request;
        }
    }
}

