/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeletePresencedefinitionRequest;
import com.mypurecloud.sdk.v2.api.request.GetPresencedefinitionRequest;
import com.mypurecloud.sdk.v2.api.request.GetPresencedefinitionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetSystempresencesRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserPresenceRequest;
import com.mypurecloud.sdk.v2.api.request.PatchUserPresenceRequest;
import com.mypurecloud.sdk.v2.api.request.PostPresencedefinitionsRequest;
import com.mypurecloud.sdk.v2.api.request.PutPresencedefinitionRequest;
import com.mypurecloud.sdk.v2.model.OrganizationPresence;
import com.mypurecloud.sdk.v2.model.OrganizationPresenceEntityListing;
import com.mypurecloud.sdk.v2.model.SystemPresence;
import com.mypurecloud.sdk.v2.model.UserPresence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PresenceApi {
    private final ApiClient pcapiClient;

    public PresenceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PresenceApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deletePresencedefinition(String presenceId) throws IOException, ApiException {
        this.deletePresencedefinitionWithHttpInfo(presenceId);
    }

    public ApiResponse<Void> deletePresencedefinitionWithHttpInfo(String presenceId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (presenceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'presenceId' when calling deletePresencedefinition");
        }
        String pclocalVarPath = "/api/v2/presencedefinitions/{presenceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{presenceId\\}", this.pcapiClient.escapeString(presenceId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deletePresencedefinition(DeletePresencedefinitionRequest request) throws IOException, ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deletePresencedefinition(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public OrganizationPresence getPresencedefinition(String presenceId, String localeCode) throws IOException, ApiException {
        return this.getPresencedefinitionWithHttpInfo(presenceId, localeCode).getBody();
    }

    public ApiResponse<OrganizationPresence> getPresencedefinitionWithHttpInfo(String presenceId, String localeCode) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (presenceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'presenceId' when calling getPresencedefinition");
        }
        String pclocalVarPath = "/api/v2/presencedefinitions/{presenceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{presenceId\\}", this.pcapiClient.escapeString(presenceId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "localeCode", localeCode));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OrganizationPresence>(){});
    }

    public OrganizationPresence getPresencedefinition(GetPresencedefinitionRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OrganizationPresence>(){});
    }

    public ApiResponse<OrganizationPresence> getPresencedefinition(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OrganizationPresence>(){});
    }

    public OrganizationPresenceEntityListing getPresencedefinitions(Integer pageNumber, Integer pageSize, String deleted, String localeCode) throws IOException, ApiException {
        return this.getPresencedefinitionsWithHttpInfo(pageNumber, pageSize, deleted, localeCode).getBody();
    }

    public ApiResponse<OrganizationPresenceEntityListing> getPresencedefinitionsWithHttpInfo(Integer pageNumber, Integer pageSize, String deleted, String localeCode) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/presencedefinitions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "deleted", deleted));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "localeCode", localeCode));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OrganizationPresenceEntityListing>(){});
    }

    public OrganizationPresenceEntityListing getPresencedefinitions(GetPresencedefinitionsRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OrganizationPresenceEntityListing>(){});
    }

    public ApiResponse<OrganizationPresenceEntityListing> getPresencedefinitions(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OrganizationPresenceEntityListing>(){});
    }

    public List<SystemPresence> getSystempresences() throws IOException, ApiException {
        return this.getSystempresencesWithHttpInfo().getBody();
    }

    public ApiResponse<List<SystemPresence>> getSystempresencesWithHttpInfo() throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/systempresences".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<List<SystemPresence>>(){});
    }

    public List<SystemPresence> getSystempresences(GetSystempresencesRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<List<SystemPresence>>(){});
    }

    public ApiResponse<List<SystemPresence>> getSystempresences(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<List<SystemPresence>>(){});
    }

    public UserPresence getUserPresence(String userId, String sourceId) throws IOException, ApiException {
        return this.getUserPresenceWithHttpInfo(userId, sourceId).getBody();
    }

    public ApiResponse<UserPresence> getUserPresenceWithHttpInfo(String userId, String sourceId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling getUserPresence");
        }
        if (sourceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'sourceId' when calling getUserPresence");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/presences/{sourceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString())).replaceAll("\\{sourceId\\}", this.pcapiClient.escapeString(sourceId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<UserPresence>(){});
    }

    public UserPresence getUserPresence(GetUserPresenceRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<UserPresence>(){});
    }

    public ApiResponse<UserPresence> getUserPresence(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<UserPresence>(){});
    }

    public UserPresence patchUserPresence(String userId, String sourceId, UserPresence body) throws IOException, ApiException {
        return this.patchUserPresenceWithHttpInfo(userId, sourceId, body).getBody();
    }

    public ApiResponse<UserPresence> patchUserPresenceWithHttpInfo(String userId, String sourceId, UserPresence body) throws IOException, ApiException {
        UserPresence pclocalVarPostBody = body;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling patchUserPresence");
        }
        if (sourceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'sourceId' when calling patchUserPresence");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling patchUserPresence");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/presences/{sourceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString())).replaceAll("\\{sourceId\\}", this.pcapiClient.escapeString(sourceId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PATCH", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<UserPresence>(){});
    }

    public UserPresence patchUserPresence(PatchUserPresenceRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<UserPresence>(){});
    }

    public ApiResponse<UserPresence> patchUserPresence(ApiRequest<UserPresence> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<UserPresence>(){});
    }

    public OrganizationPresence postPresencedefinitions(OrganizationPresence body) throws IOException, ApiException {
        return this.postPresencedefinitionsWithHttpInfo(body).getBody();
    }

    public ApiResponse<OrganizationPresence> postPresencedefinitionsWithHttpInfo(OrganizationPresence body) throws IOException, ApiException {
        OrganizationPresence pclocalVarPostBody = body;
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling postPresencedefinitions");
        }
        String pclocalVarPath = "/api/v2/presencedefinitions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OrganizationPresence>(){});
    }

    public OrganizationPresence postPresencedefinitions(PostPresencedefinitionsRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OrganizationPresence>(){});
    }

    public ApiResponse<OrganizationPresence> postPresencedefinitions(ApiRequest<OrganizationPresence> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OrganizationPresence>(){});
    }

    public OrganizationPresence putPresencedefinition(String presenceId, OrganizationPresence body) throws IOException, ApiException {
        return this.putPresencedefinitionWithHttpInfo(presenceId, body).getBody();
    }

    public ApiResponse<OrganizationPresence> putPresencedefinitionWithHttpInfo(String presenceId, OrganizationPresence body) throws IOException, ApiException {
        OrganizationPresence pclocalVarPostBody = body;
        if (presenceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'presenceId' when calling putPresencedefinition");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling putPresencedefinition");
        }
        String pclocalVarPath = "/api/v2/presencedefinitions/{presenceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{presenceId\\}", this.pcapiClient.escapeString(presenceId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OrganizationPresence>(){});
    }

    public OrganizationPresence putPresencedefinition(PutPresencedefinitionRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OrganizationPresence>(){});
    }

    public ApiResponse<OrganizationPresence> putPresencedefinition(ApiRequest<OrganizationPresence> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OrganizationPresence>(){});
    }
}

