/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteFaxDocumentRequest;
import com.mypurecloud.sdk.v2.api.request.GetFaxDocumentContentRequest;
import com.mypurecloud.sdk.v2.api.request.GetFaxDocumentRequest;
import com.mypurecloud.sdk.v2.api.request.GetFaxDocumentsRequest;
import com.mypurecloud.sdk.v2.api.request.GetFaxSummaryRequest;
import com.mypurecloud.sdk.v2.api.request.PutFaxDocumentRequest;
import com.mypurecloud.sdk.v2.model.DownloadResponse;
import com.mypurecloud.sdk.v2.model.FaxDocument;
import com.mypurecloud.sdk.v2.model.FaxDocumentEntityListing;
import com.mypurecloud.sdk.v2.model.FaxSummary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class FaxApi {
    private final ApiClient pcapiClient;

    public FaxApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FaxApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteFaxDocument(String documentId) throws IOException, ApiException {
        this.deleteFaxDocumentWithHttpInfo(documentId);
    }

    public ApiResponse<Void> deleteFaxDocumentWithHttpInfo(String documentId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (documentId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'documentId' when calling deleteFaxDocument");
        }
        String pclocalVarPath = "/api/v2/fax/documents/{documentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{documentId\\}", this.pcapiClient.escapeString(documentId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteFaxDocument(DeleteFaxDocumentRequest request) throws IOException, ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteFaxDocument(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public FaxDocument getFaxDocument(String documentId) throws IOException, ApiException {
        return this.getFaxDocumentWithHttpInfo(documentId).getBody();
    }

    public ApiResponse<FaxDocument> getFaxDocumentWithHttpInfo(String documentId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (documentId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'documentId' when calling getFaxDocument");
        }
        String pclocalVarPath = "/api/v2/fax/documents/{documentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{documentId\\}", this.pcapiClient.escapeString(documentId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<FaxDocument>(){});
    }

    public FaxDocument getFaxDocument(GetFaxDocumentRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<FaxDocument>(){});
    }

    public ApiResponse<FaxDocument> getFaxDocument(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<FaxDocument>(){});
    }

    public DownloadResponse getFaxDocumentContent(String documentId) throws IOException, ApiException {
        return this.getFaxDocumentContentWithHttpInfo(documentId).getBody();
    }

    public ApiResponse<DownloadResponse> getFaxDocumentContentWithHttpInfo(String documentId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (documentId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'documentId' when calling getFaxDocumentContent");
        }
        String pclocalVarPath = "/api/v2/fax/documents/{documentId}/content".replaceAll("\\{format\\}", "json").replaceAll("\\{documentId\\}", this.pcapiClient.escapeString(documentId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DownloadResponse>(){});
    }

    public DownloadResponse getFaxDocumentContent(GetFaxDocumentContentRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DownloadResponse>(){});
    }

    public ApiResponse<DownloadResponse> getFaxDocumentContent(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DownloadResponse>(){});
    }

    public FaxDocumentEntityListing getFaxDocuments(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getFaxDocumentsWithHttpInfo(pageSize, pageNumber).getBody();
    }

    public ApiResponse<FaxDocumentEntityListing> getFaxDocumentsWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/fax/documents".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<FaxDocumentEntityListing>(){});
    }

    public FaxDocumentEntityListing getFaxDocuments(GetFaxDocumentsRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<FaxDocumentEntityListing>(){});
    }

    public ApiResponse<FaxDocumentEntityListing> getFaxDocuments(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<FaxDocumentEntityListing>(){});
    }

    public FaxSummary getFaxSummary() throws IOException, ApiException {
        return this.getFaxSummaryWithHttpInfo().getBody();
    }

    public ApiResponse<FaxSummary> getFaxSummaryWithHttpInfo() throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/fax/summary".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<FaxSummary>(){});
    }

    public FaxSummary getFaxSummary(GetFaxSummaryRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<FaxSummary>(){});
    }

    public ApiResponse<FaxSummary> getFaxSummary(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<FaxSummary>(){});
    }

    public FaxDocument putFaxDocument(String documentId, FaxDocument body) throws IOException, ApiException {
        return this.putFaxDocumentWithHttpInfo(documentId, body).getBody();
    }

    public ApiResponse<FaxDocument> putFaxDocumentWithHttpInfo(String documentId, FaxDocument body) throws IOException, ApiException {
        FaxDocument pclocalVarPostBody = body;
        if (documentId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'documentId' when calling putFaxDocument");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling putFaxDocument");
        }
        String pclocalVarPath = "/api/v2/fax/documents/{documentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{documentId\\}", this.pcapiClient.escapeString(documentId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<FaxDocument>(){});
    }

    public FaxDocument putFaxDocument(PutFaxDocumentRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<FaxDocument>(){});
    }

    public ApiResponse<FaxDocument> putFaxDocument(ApiRequest<FaxDocument> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<FaxDocument>(){});
    }
}

