/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Library;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutResponsemanagementLibraryRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String libraryId;
    private Library body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getLibraryId() {
        return this.libraryId;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public PutResponsemanagementLibraryRequest withLibraryId(String libraryId) {
        this.setLibraryId(libraryId);
        return this;
    }

    public Library getBody() {
        return this.body;
    }

    public void setBody(Library body) {
        this.body = body;
    }

    public PutResponsemanagementLibraryRequest withBody(Library body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutResponsemanagementLibraryRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Library> withHttpInfo() {
        if (this.libraryId == null) {
            throw new IllegalStateException("Missing the required parameter 'libraryId' when building request for PutResponsemanagementLibraryRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutResponsemanagementLibraryRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/responsemanagement/libraries/{libraryId}").withPathParameter("libraryId", this.libraryId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String libraryId, Library body) {
        return new Builder().withRequiredParams(libraryId, body);
    }

    public static class Builder {
        private final PutResponsemanagementLibraryRequest request = new PutResponsemanagementLibraryRequest();

        private Builder() {
        }

        public Builder withLibraryId(String libraryId) {
            this.request.setLibraryId(libraryId);
            return this;
        }

        public Builder withBody(Library body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String libraryId, Library body) {
            this.request.setLibraryId(libraryId);
            this.request.setBody(body);
            return this;
        }

        public PutResponsemanagementLibraryRequest build() {
            return this.request;
        }
    }
}

