/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SuggestSearchRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostSearchSuggestRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private SuggestSearchRequest body;
    private Boolean profile;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public SuggestSearchRequest getBody() {
        return this.body;
    }

    public void setBody(SuggestSearchRequest body) {
        this.body = body;
    }

    public PostSearchSuggestRequest withBody(SuggestSearchRequest body) {
        this.setBody(body);
        return this;
    }

    public Boolean getProfile() {
        return this.profile;
    }

    public void setProfile(Boolean profile) {
        this.profile = profile;
    }

    public PostSearchSuggestRequest withProfile(Boolean profile) {
        this.setProfile(profile);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostSearchSuggestRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SuggestSearchRequest> withHttpInfo() {
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostSearchSuggestRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/search/suggest").withQueryParameters("profile", "", this.profile).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SuggestSearchRequest body) {
        return new Builder().withRequiredParams(body);
    }

    public static class Builder {
        private final PostSearchSuggestRequest request = new PostSearchSuggestRequest();

        private Builder() {
        }

        public Builder withBody(SuggestSearchRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withProfile(Boolean profile) {
            this.request.setProfile(profile);
            return this;
        }

        public Builder withRequiredParams(SuggestSearchRequest body) {
            this.request.setBody(body);
            return this;
        }

        public PostSearchSuggestRequest build() {
            return this.request;
        }
    }
}

