/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ConsultTransfer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostConversationsCallParticipantConsultRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String callId;
    private String participantId;
    private ConsultTransfer body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public PostConversationsCallParticipantConsultRequest withCallId(String callId) {
        this.setCallId(callId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PostConversationsCallParticipantConsultRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public ConsultTransfer getBody() {
        return this.body;
    }

    public void setBody(ConsultTransfer body) {
        this.body = body;
    }

    public PostConversationsCallParticipantConsultRequest withBody(ConsultTransfer body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsCallParticipantConsultRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ConsultTransfer> withHttpInfo() {
        if (this.callId == null) {
            throw new IllegalStateException("Missing the required parameter 'callId' when building request for PostConversationsCallParticipantConsultRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PostConversationsCallParticipantConsultRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsCallParticipantConsultRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/calls/{callId}/participants/{participantId}/consult").withPathParameter("callId", this.callId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callId, String participantId, ConsultTransfer body) {
        return new Builder().withRequiredParams(callId, participantId, body);
    }

    public static class Builder {
        private final PostConversationsCallParticipantConsultRequest request = new PostConversationsCallParticipantConsultRequest();

        private Builder() {
        }

        public Builder withCallId(String callId) {
            this.request.setCallId(callId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(ConsultTransfer body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String callId, String participantId, ConsultTransfer body) {
            this.request.setCallId(callId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsCallParticipantConsultRequest build() {
            return this.request;
        }
    }
}

