/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.MediaParticipantRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchConversationsCallParticipantRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String callId;
    private String participantId;
    private MediaParticipantRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public PatchConversationsCallParticipantRequest withCallId(String callId) {
        this.setCallId(callId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PatchConversationsCallParticipantRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public MediaParticipantRequest getBody() {
        return this.body;
    }

    public void setBody(MediaParticipantRequest body) {
        this.body = body;
    }

    public PatchConversationsCallParticipantRequest withBody(MediaParticipantRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsCallParticipantRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<MediaParticipantRequest> withHttpInfo() {
        if (this.callId == null) {
            throw new IllegalStateException("Missing the required parameter 'callId' when building request for PatchConversationsCallParticipantRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsCallParticipantRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsCallParticipantRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/calls/{callId}/participants/{participantId}").withPathParameter("callId", this.callId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callId, String participantId, MediaParticipantRequest body) {
        return new Builder().withRequiredParams(callId, participantId, body);
    }

    public static class Builder {
        private final PatchConversationsCallParticipantRequest request = new PatchConversationsCallParticipantRequest();

        private Builder() {
        }

        public Builder withCallId(String callId) {
            this.request.setCallId(callId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(MediaParticipantRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String callId, String participantId, MediaParticipantRequest body) {
            this.request.setCallId(callId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsCallParticipantRequest build() {
            return this.request;
        }
    }
}

