/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetGreetingMediaRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String greetingId;
    private String formatId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGreetingId() {
        return this.greetingId;
    }

    public void setGreetingId(String greetingId) {
        this.greetingId = greetingId;
    }

    public GetGreetingMediaRequest withGreetingId(String greetingId) {
        this.setGreetingId(greetingId);
        return this;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }

    public GetGreetingMediaRequest withFormatId(String formatId) {
        this.setFormatId(formatId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGreetingMediaRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.greetingId == null) {
            throw new IllegalStateException("Missing the required parameter 'greetingId' when building request for GetGreetingMediaRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/greetings/{greetingId}/media").withPathParameter("greetingId", this.greetingId).withQueryParameters("formatId", "", this.formatId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String greetingId) {
        return new Builder().withRequiredParams(greetingId);
    }

    public static class Builder {
        private final GetGreetingMediaRequest request = new GetGreetingMediaRequest();

        private Builder() {
        }

        public Builder withGreetingId(String greetingId) {
            this.request.setGreetingId(greetingId);
            return this;
        }

        public Builder withFormatId(String formatId) {
            this.request.setFormatId(formatId);
            return this;
        }

        public Builder withRequiredParams(String greetingId) {
            this.request.setGreetingId(greetingId);
            return this;
        }

        public GetGreetingMediaRequest build() {
            return this.request;
        }
    }
}

