/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetConversationsChatRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String chatId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public GetConversationsChatRequest withChatId(String chatId) {
        this.setChatId(chatId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationsChatRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.chatId == null) {
            throw new IllegalStateException("Missing the required parameter 'chatId' when building request for GetConversationsChatRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/chats/{chatId}").withPathParameter("chatId", this.chatId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String chatId) {
        return new Builder().withRequiredParams(chatId);
    }

    public static class Builder {
        private final GetConversationsChatRequest request = new GetConversationsChatRequest();

        private Builder() {
        }

        public Builder withChatId(String chatId) {
            this.request.setChatId(chatId);
            return this;
        }

        public Builder withRequiredParams(String chatId) {
            this.request.setChatId(chatId);
            return this;
        }

        public GetConversationsChatRequest build() {
            return this.request;
        }
    }
}

