/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Request to move agents into or out of a management unit")
public class MoveAgentsRequest
implements Serializable {
    private List<String> userIds = new ArrayList<String>();
    private String destinationManagementUnitId = null;

    public MoveAgentsRequest userIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of user ids to move")
    @JsonProperty(value="userIds")
    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public MoveAgentsRequest destinationManagementUnitId(String destinationManagementUnitId) {
        this.destinationManagementUnitId = destinationManagementUnitId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the management unit for which the move will be performed. To remove users from their management unit this should be set to null.")
    @JsonProperty(value="destinationManagementUnitId")
    public String getDestinationManagementUnitId() {
        return this.destinationManagementUnitId;
    }

    public void setDestinationManagementUnitId(String destinationManagementUnitId) {
        this.destinationManagementUnitId = destinationManagementUnitId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoveAgentsRequest moveAgentsRequest = (MoveAgentsRequest)o;
        return Objects.equals(this.userIds, moveAgentsRequest.userIds) && Objects.equals(this.destinationManagementUnitId, moveAgentsRequest.destinationManagementUnitId);
    }

    public int hashCode() {
        return Objects.hash(this.userIds, this.destinationManagementUnitId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MoveAgentsRequest {\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    destinationManagementUnitId: ").append(this.toIndentedString(this.destinationManagementUnitId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

