/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class TransfersFullTimeEquivalent
implements Serializable {
    private String destinationStaffingGroupId = null;
    private TransferTypeEnum transferType = null;

    public TransfersFullTimeEquivalent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public TransfersFullTimeEquivalent destinationStaffingGroupId(String destinationStaffingGroupId) {
        this.destinationStaffingGroupId = destinationStaffingGroupId;
        return this;
    }

    @ApiModelProperty(example="null", value="The target staffing group that will receive the full time equivalent when agents are transferred from one staffing group to another")
    @JsonProperty(value="destinationStaffingGroupId")
    public String getDestinationStaffingGroupId() {
        return this.destinationStaffingGroupId;
    }

    public void setDestinationStaffingGroupId(String destinationStaffingGroupId) {
        this.destinationStaffingGroupId = destinationStaffingGroupId;
    }

    public TransfersFullTimeEquivalent transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @ApiModelProperty(example="null", value="The duration of the transfer full time equivalent from one staffing group to another")
    @JsonProperty(value="transferType")
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransfersFullTimeEquivalent transfersFullTimeEquivalent = (TransfersFullTimeEquivalent)o;
        return Objects.equals(this.destinationStaffingGroupId, transfersFullTimeEquivalent.destinationStaffingGroupId) && Objects.equals((Object)this.transferType, (Object)transfersFullTimeEquivalent.transferType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.destinationStaffingGroupId, this.transferType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransfersFullTimeEquivalent {\n");
        sb.append("    destinationStaffingGroupId: ").append(this.toIndentedString(this.destinationStaffingGroupId)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TransferTypeEnumDeserializer.class)
    public static enum TransferTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PERMANENT("Permanent"),
        TEMPORARY("Temporary");

        private String value;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TransferTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TransferTypeEnum value : TransferTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TransferTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TransferTypeEnumDeserializer
    extends StdDeserializer<TransferTypeEnum> {
        public TransferTypeEnumDeserializer() {
            super(TransferTypeEnumDeserializer.class);
        }

        public TransferTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TransferTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

