/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class TimeOffSettingsResponse
implements Serializable {
    private Boolean submissionRangeEnforced = null;
    private SubmissionRangeTypeEnum submissionRangeType = null;
    private Integer submissionEarliestDaysFromNow = null;
    private Integer submissionLatestDaysFromNow = null;
    private LocalDate submissionLatestDate = null;

    public TimeOffSettingsResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public TimeOffSettingsResponse submissionRangeEnforced(Boolean submissionRangeEnforced) {
        this.submissionRangeEnforced = submissionRangeEnforced;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to enforce a submission range for agent time off requests")
    @JsonProperty(value="submissionRangeEnforced")
    public Boolean getSubmissionRangeEnforced() {
        return this.submissionRangeEnforced;
    }

    public void setSubmissionRangeEnforced(Boolean submissionRangeEnforced) {
        this.submissionRangeEnforced = submissionRangeEnforced;
    }

    public TimeOffSettingsResponse submissionRangeType(SubmissionRangeTypeEnum submissionRangeType) {
        this.submissionRangeType = submissionRangeType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the submission range")
    @JsonProperty(value="submissionRangeType")
    public SubmissionRangeTypeEnum getSubmissionRangeType() {
        return this.submissionRangeType;
    }

    public void setSubmissionRangeType(SubmissionRangeTypeEnum submissionRangeType) {
        this.submissionRangeType = submissionRangeType;
    }

    public TimeOffSettingsResponse submissionEarliestDaysFromNow(Integer submissionEarliestDaysFromNow) {
        this.submissionEarliestDaysFromNow = submissionEarliestDaysFromNow;
        return this;
    }

    @ApiModelProperty(example="null", value="The earliest number of days from now for which an agent can submit a time off request.  Use negative numbers to indicate days in the past")
    @JsonProperty(value="submissionEarliestDaysFromNow")
    public Integer getSubmissionEarliestDaysFromNow() {
        return this.submissionEarliestDaysFromNow;
    }

    public void setSubmissionEarliestDaysFromNow(Integer submissionEarliestDaysFromNow) {
        this.submissionEarliestDaysFromNow = submissionEarliestDaysFromNow;
    }

    public TimeOffSettingsResponse submissionLatestDaysFromNow(Integer submissionLatestDaysFromNow) {
        this.submissionLatestDaysFromNow = submissionLatestDaysFromNow;
        return this;
    }

    @ApiModelProperty(example="null", value="The latest number of days from now for which an agent can submit a time off request")
    @JsonProperty(value="submissionLatestDaysFromNow")
    public Integer getSubmissionLatestDaysFromNow() {
        return this.submissionLatestDaysFromNow;
    }

    public void setSubmissionLatestDaysFromNow(Integer submissionLatestDaysFromNow) {
        this.submissionLatestDaysFromNow = submissionLatestDaysFromNow;
    }

    public TimeOffSettingsResponse submissionLatestDate(LocalDate submissionLatestDate) {
        this.submissionLatestDate = submissionLatestDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The latest date for the time off request submission interpreted in the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="submissionLatestDate")
    public LocalDate getSubmissionLatestDate() {
        return this.submissionLatestDate;
    }

    public void setSubmissionLatestDate(LocalDate submissionLatestDate) {
        this.submissionLatestDate = submissionLatestDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeOffSettingsResponse timeOffSettingsResponse = (TimeOffSettingsResponse)o;
        return Objects.equals(this.submissionRangeEnforced, timeOffSettingsResponse.submissionRangeEnforced) && Objects.equals((Object)this.submissionRangeType, (Object)timeOffSettingsResponse.submissionRangeType) && Objects.equals(this.submissionEarliestDaysFromNow, timeOffSettingsResponse.submissionEarliestDaysFromNow) && Objects.equals(this.submissionLatestDaysFromNow, timeOffSettingsResponse.submissionLatestDaysFromNow) && Objects.equals(this.submissionLatestDate, timeOffSettingsResponse.submissionLatestDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.submissionRangeEnforced, this.submissionRangeType, this.submissionEarliestDaysFromNow, this.submissionLatestDaysFromNow, this.submissionLatestDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeOffSettingsResponse {\n");
        sb.append("    submissionRangeEnforced: ").append(this.toIndentedString(this.submissionRangeEnforced)).append("\n");
        sb.append("    submissionRangeType: ").append(this.toIndentedString((Object)this.submissionRangeType)).append("\n");
        sb.append("    submissionEarliestDaysFromNow: ").append(this.toIndentedString(this.submissionEarliestDaysFromNow)).append("\n");
        sb.append("    submissionLatestDaysFromNow: ").append(this.toIndentedString(this.submissionLatestDaysFromNow)).append("\n");
        sb.append("    submissionLatestDate: ").append(this.toIndentedString(this.submissionLatestDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SubmissionRangeTypeEnumDeserializer.class)
    public static enum SubmissionRangeTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RELATIVE("Relative"),
        FIXEDEND("FixedEnd");

        private String value;

        private SubmissionRangeTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SubmissionRangeTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SubmissionRangeTypeEnum value : SubmissionRangeTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SubmissionRangeTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SubmissionRangeTypeEnumDeserializer
    extends StdDeserializer<SubmissionRangeTypeEnum> {
        public SubmissionRangeTypeEnumDeserializer() {
            super(SubmissionRangeTypeEnumDeserializer.class);
        }

        public SubmissionRangeTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SubmissionRangeTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

