/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.TimeOffLimitReference;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TimeOffLimitValueRange
implements Serializable {
    private TimeOffLimitReference timeOffLimit = null;
    private LocalDate startDate = null;
    private GranularityEnum granularity = null;
    private List<Integer> limitMinutesPerInterval = null;
    private List<Integer> allocatedMinutesPerInterval = null;
    private List<Integer> waitlistedMinutesPerInterval = null;
    private List<Integer> waitlistedRequestsPerInterval = null;
    private WfmVersionedEntityMetadata metadata = null;

    public TimeOffLimitValueRange() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.limitMinutesPerInterval = new ArrayList<Integer>();
            this.allocatedMinutesPerInterval = new ArrayList<Integer>();
            this.waitlistedMinutesPerInterval = new ArrayList<Integer>();
            this.waitlistedRequestsPerInterval = new ArrayList<Integer>();
        }
    }

    public TimeOffLimitValueRange timeOffLimit(TimeOffLimitReference timeOffLimit) {
        this.timeOffLimit = timeOffLimit;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the time off limit")
    @JsonProperty(value="timeOffLimit")
    public TimeOffLimitReference getTimeOffLimit() {
        return this.timeOffLimit;
    }

    public void setTimeOffLimit(TimeOffLimitReference timeOffLimit) {
        this.timeOffLimit = timeOffLimit;
    }

    public TimeOffLimitValueRange startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Start date of the requested date range, in ISO-8601 format. The end date is determined by the size of interval lists")
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public TimeOffLimitValueRange granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Granularity choice for time off limit")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public TimeOffLimitValueRange limitMinutesPerInterval(List<Integer> limitMinutesPerInterval) {
        this.limitMinutesPerInterval = limitMinutesPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of time off limit values in minutes per granularity interval")
    @JsonProperty(value="limitMinutesPerInterval")
    public List<Integer> getLimitMinutesPerInterval() {
        return this.limitMinutesPerInterval;
    }

    public void setLimitMinutesPerInterval(List<Integer> limitMinutesPerInterval) {
        this.limitMinutesPerInterval = limitMinutesPerInterval;
    }

    public TimeOffLimitValueRange allocatedMinutesPerInterval(List<Integer> allocatedMinutesPerInterval) {
        this.allocatedMinutesPerInterval = allocatedMinutesPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of allocated time off minutes per granularity interval")
    @JsonProperty(value="allocatedMinutesPerInterval")
    public List<Integer> getAllocatedMinutesPerInterval() {
        return this.allocatedMinutesPerInterval;
    }

    public void setAllocatedMinutesPerInterval(List<Integer> allocatedMinutesPerInterval) {
        this.allocatedMinutesPerInterval = allocatedMinutesPerInterval;
    }

    public TimeOffLimitValueRange waitlistedMinutesPerInterval(List<Integer> waitlistedMinutesPerInterval) {
        this.waitlistedMinutesPerInterval = waitlistedMinutesPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of waitlisted time off minutes per granularity interval")
    @JsonProperty(value="waitlistedMinutesPerInterval")
    public List<Integer> getWaitlistedMinutesPerInterval() {
        return this.waitlistedMinutesPerInterval;
    }

    public void setWaitlistedMinutesPerInterval(List<Integer> waitlistedMinutesPerInterval) {
        this.waitlistedMinutesPerInterval = waitlistedMinutesPerInterval;
    }

    public TimeOffLimitValueRange waitlistedRequestsPerInterval(List<Integer> waitlistedRequestsPerInterval) {
        this.waitlistedRequestsPerInterval = waitlistedRequestsPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", value="The current number of waitlisted time off requests for every interval per granularity")
    @JsonProperty(value="waitlistedRequestsPerInterval")
    public List<Integer> getWaitlistedRequestsPerInterval() {
        return this.waitlistedRequestsPerInterval;
    }

    public void setWaitlistedRequestsPerInterval(List<Integer> waitlistedRequestsPerInterval) {
        this.waitlistedRequestsPerInterval = waitlistedRequestsPerInterval;
    }

    public TimeOffLimitValueRange metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Version metadata for the time off limit")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeOffLimitValueRange timeOffLimitValueRange = (TimeOffLimitValueRange)o;
        return Objects.equals(this.timeOffLimit, timeOffLimitValueRange.timeOffLimit) && Objects.equals(this.startDate, timeOffLimitValueRange.startDate) && Objects.equals((Object)this.granularity, (Object)timeOffLimitValueRange.granularity) && Objects.equals(this.limitMinutesPerInterval, timeOffLimitValueRange.limitMinutesPerInterval) && Objects.equals(this.allocatedMinutesPerInterval, timeOffLimitValueRange.allocatedMinutesPerInterval) && Objects.equals(this.waitlistedMinutesPerInterval, timeOffLimitValueRange.waitlistedMinutesPerInterval) && Objects.equals(this.waitlistedRequestsPerInterval, timeOffLimitValueRange.waitlistedRequestsPerInterval) && Objects.equals(this.metadata, timeOffLimitValueRange.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeOffLimit, this.startDate, this.granularity, this.limitMinutesPerInterval, this.allocatedMinutesPerInterval, this.waitlistedMinutesPerInterval, this.waitlistedRequestsPerInterval, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeOffLimitValueRange {\n");
        sb.append("    timeOffLimit: ").append(this.toIndentedString(this.timeOffLimit)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    limitMinutesPerInterval: ").append(this.toIndentedString(this.limitMinutesPerInterval)).append("\n");
        sb.append("    allocatedMinutesPerInterval: ").append(this.toIndentedString(this.allocatedMinutesPerInterval)).append("\n");
        sb.append("    waitlistedMinutesPerInterval: ").append(this.toIndentedString(this.waitlistedMinutesPerInterval)).append("\n");
        sb.append("    waitlistedRequestsPerInterval: ").append(this.toIndentedString(this.waitlistedRequestsPerInterval)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily"),
        FIFTEENMINUTES("FifteenMinutes");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

