/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ShiftTradeActivityRule
implements Serializable {
    private ActivityCategoryEnum activityCategory = null;
    private ActionEnum action = null;
    private String activityCodeIdReplacement = null;

    public ShiftTradeActivityRule() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ShiftTradeActivityRule activityCategory(ActivityCategoryEnum activityCategory) {
        this.activityCategory = activityCategory;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The activity category to which to apply this rule")
    @JsonProperty(value="activityCategory")
    public ActivityCategoryEnum getActivityCategory() {
        return this.activityCategory;
    }

    public void setActivityCategory(ActivityCategoryEnum activityCategory) {
        this.activityCategory = activityCategory;
    }

    public ShiftTradeActivityRule action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The action this rule invokes")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public ShiftTradeActivityRule activityCodeIdReplacement(String activityCodeIdReplacement) {
        this.activityCodeIdReplacement = activityCodeIdReplacement;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the activity code with which to replace activities belonging to the original category if applicable (required if action == Replace, must be a default activity code ID)")
    @JsonProperty(value="activityCodeIdReplacement")
    public String getActivityCodeIdReplacement() {
        return this.activityCodeIdReplacement;
    }

    public void setActivityCodeIdReplacement(String activityCodeIdReplacement) {
        this.activityCodeIdReplacement = activityCodeIdReplacement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftTradeActivityRule shiftTradeActivityRule = (ShiftTradeActivityRule)o;
        return Objects.equals((Object)this.activityCategory, (Object)shiftTradeActivityRule.activityCategory) && Objects.equals((Object)this.action, (Object)shiftTradeActivityRule.action) && Objects.equals(this.activityCodeIdReplacement, shiftTradeActivityRule.activityCodeIdReplacement);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activityCategory, this.action, this.activityCodeIdReplacement});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftTradeActivityRule {\n");
        sb.append("    activityCategory: ").append(this.toIndentedString((Object)this.activityCategory)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    activityCodeIdReplacement: ").append(this.toIndentedString(this.activityCodeIdReplacement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActivityCategoryEnumDeserializer.class)
    public static enum ActivityCategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable");

        private String value;

        private ActivityCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivityCategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivityCategoryEnum value : ActivityCategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivityCategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REPLACE("Replace"),
        DONOTALLOWTRADE("DoNotAllowTrade"),
        KEEPWITHSCHEDULE("KeepWithSchedule");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ActivityCategoryEnumDeserializer
    extends StdDeserializer<ActivityCategoryEnum> {
        public ActivityCategoryEnumDeserializer() {
            super(ActivityCategoryEnumDeserializer.class);
        }

        public ActivityCategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActivityCategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

