/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Manager;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Defines a SCIM enterprise user.")
public class ScimV2EnterpriseUser
implements Serializable {
    private String division = null;
    private String department = null;
    private Manager manager = null;
    private String employeeNumber = null;
    private String dateHire = null;

    public ScimV2EnterpriseUser() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ScimV2EnterpriseUser division(String division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division that the user belongs to.")
    @JsonProperty(value="division")
    public String getDivision() {
        return this.division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public ScimV2EnterpriseUser department(String department) {
        this.department = department;
        return this;
    }

    @ApiModelProperty(example="null", value="The department that the user belongs to.")
    @JsonProperty(value="department")
    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public ScimV2EnterpriseUser manager(Manager manager) {
        this.manager = manager;
        return this;
    }

    @ApiModelProperty(example="null", value="The user's manager.")
    @JsonProperty(value="manager")
    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public ScimV2EnterpriseUser employeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The user's employee number.")
    @JsonProperty(value="employeeNumber")
    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public ScimV2EnterpriseUser dateHire(String dateHire) {
        this.dateHire = dateHire;
        return this;
    }

    @ApiModelProperty(example="null", value="The user's hire date. Format in JSON will be YYYY-MM-DD.")
    @JsonProperty(value="dateHire")
    public String getDateHire() {
        return this.dateHire;
    }

    public void setDateHire(String dateHire) {
        this.dateHire = dateHire;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2EnterpriseUser scimV2EnterpriseUser = (ScimV2EnterpriseUser)o;
        return Objects.equals(this.division, scimV2EnterpriseUser.division) && Objects.equals(this.department, scimV2EnterpriseUser.department) && Objects.equals(this.manager, scimV2EnterpriseUser.manager) && Objects.equals(this.employeeNumber, scimV2EnterpriseUser.employeeNumber) && Objects.equals(this.dateHire, scimV2EnterpriseUser.dateHire);
    }

    public int hashCode() {
        return Objects.hash(this.division, this.department, this.manager, this.employeeNumber, this.dateHire);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2EnterpriseUser {\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    department: ").append(this.toIndentedString(this.department)).append("\n");
        sb.append("    manager: ").append(this.toIndentedString(this.manager)).append("\n");
        sb.append("    employeeNumber: ").append(this.toIndentedString(this.employeeNumber)).append("\n");
        sb.append("    dateHire: ").append(this.toIndentedString(this.dateHire)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

