/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.GuideVersionResources;
import com.mypurecloud.sdk.v2.model.Variable;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class GuideVersion
implements Serializable {
    private String selfUri = null;
    private AddressableEntityRef guide = null;
    private String version = null;
    private String instruction = null;
    private StateEnum state = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private List<Variable> variables = null;
    private GuideVersionResources resources = null;

    public GuideVersion() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.variables = new ArrayList<Variable>();
        }
    }

    public GuideVersion selfUri(String selfUri) {
        this.selfUri = selfUri;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public void setSelfUri(String selfUri) {
        this.selfUri = selfUri;
    }

    @ApiModelProperty(example="null", value="The guide this version belongs to.")
    @JsonProperty(value="guide")
    public AddressableEntityRef getGuide() {
        return this.guide;
    }

    @ApiModelProperty(example="null", value="Guide version.")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @ApiModelProperty(example="null", value="The instruction given to this version of the guide, for how it should behave when interacting with a User.")
    @JsonProperty(value="instruction")
    public String getInstruction() {
        return this.instruction;
    }

    public GuideVersion state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The current state of the guide version.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    @ApiModelProperty(example="null", value="The date and time the guide version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date and time the guide version was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The variables associated with this version of the guide. Includes input variables (provided) and output variables (captured during execution).")
    @JsonProperty(value="variables")
    public List<Variable> getVariables() {
        return this.variables;
    }

    public GuideVersion resources(GuideVersionResources resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(example="null", value="The resources associated with this version of the guide.")
    @JsonProperty(value="resources")
    public GuideVersionResources getResources() {
        return this.resources;
    }

    public void setResources(GuideVersionResources resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuideVersion guideVersion = (GuideVersion)o;
        return Objects.equals(this.selfUri, guideVersion.selfUri) && Objects.equals(this.guide, guideVersion.guide) && Objects.equals(this.version, guideVersion.version) && Objects.equals(this.instruction, guideVersion.instruction) && Objects.equals((Object)this.state, (Object)guideVersion.state) && Objects.equals(this.dateCreated, guideVersion.dateCreated) && Objects.equals(this.dateModified, guideVersion.dateModified) && Objects.equals(this.variables, guideVersion.variables) && Objects.equals(this.resources, guideVersion.resources);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.selfUri, this.guide, this.version, this.instruction, this.state, this.dateCreated, this.dateModified, this.variables, this.resources});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GuideVersion {\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    guide: ").append(this.toIndentedString(this.guide)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    instruction: ").append(this.toIndentedString(this.instruction)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DRAFT("Draft"),
        TESTREADY("TestReady"),
        PRODUCTIONREADY("ProductionReady");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

