/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DocumentQueryClause;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentQuery
implements Serializable {
    private List<DocumentQueryClause> clauses = null;
    private OperatorEnum operator = null;

    public DocumentQuery() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.clauses = new ArrayList<DocumentQueryClause>();
        }
    }

    public DocumentQuery clauses(List<DocumentQueryClause> clauses) {
        this.clauses = clauses;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Documents filter clauses/criteria. Limit of 20 clauses.")
    @JsonProperty(value="clauses")
    public List<DocumentQueryClause> getClauses() {
        return this.clauses;
    }

    public void setClauses(List<DocumentQueryClause> clauses) {
        this.clauses = clauses;
    }

    public DocumentQuery operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies how the filter clauses will be applied together.")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentQuery documentQuery = (DocumentQuery)o;
        return Objects.equals(this.clauses, documentQuery.clauses) && Objects.equals((Object)this.operator, (Object)documentQuery.operator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clauses, this.operator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentQuery {\n");
        sb.append("    clauses: ").append(this.toIndentedString(this.clauses)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OR("Or"),
        AND("And");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

