/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.PredictorSchedule;
import com.mypurecloud.sdk.v2.model.PredictorWorkloadBalancing;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreatePredictorRequest
implements Serializable {
    private List<String> queueIds = null;
    private String kpi = null;
    private Integer routingTimeoutSeconds = null;
    private PredictorSchedule schedule = null;
    private PredictorWorkloadBalancing workloadBalancingConfig = null;

    public CreatePredictorRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.queueIds = new ArrayList<String>();
        }
    }

    public CreatePredictorRequest queueIds(List<String> queueIds) {
        this.queueIds = queueIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The queue IDs associated with the predictor.")
    @JsonProperty(value="queueIds")
    public List<String> getQueueIds() {
        return this.queueIds;
    }

    public void setQueueIds(List<String> queueIds) {
        this.queueIds = queueIds;
    }

    public CreatePredictorRequest kpi(String kpi) {
        this.kpi = kpi;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The KPI that the predictor attempts to maximize/minimize.")
    @JsonProperty(value="kpi")
    public String getKpi() {
        return this.kpi;
    }

    public void setKpi(String kpi) {
        this.kpi = kpi;
    }

    public CreatePredictorRequest routingTimeoutSeconds(Integer routingTimeoutSeconds) {
        this.routingTimeoutSeconds = routingTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of seconds allocated to predictive routing before attempting a different routing method. This is a value between 12 and 900 seconds.")
    @JsonProperty(value="routingTimeoutSeconds")
    public Integer getRoutingTimeoutSeconds() {
        return this.routingTimeoutSeconds;
    }

    public void setRoutingTimeoutSeconds(Integer routingTimeoutSeconds) {
        this.routingTimeoutSeconds = routingTimeoutSeconds;
    }

    public CreatePredictorRequest schedule(PredictorSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="null", value="The predictor schedule that determines when the predictor is used for routing interactions.")
    @JsonProperty(value="schedule")
    public PredictorSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(PredictorSchedule schedule) {
        this.schedule = schedule;
    }

    public CreatePredictorRequest workloadBalancingConfig(PredictorWorkloadBalancing workloadBalancingConfig) {
        this.workloadBalancingConfig = workloadBalancingConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="The predictor balancing configuration to enable workload balancing")
    @JsonProperty(value="workloadBalancingConfig")
    public PredictorWorkloadBalancing getWorkloadBalancingConfig() {
        return this.workloadBalancingConfig;
    }

    public void setWorkloadBalancingConfig(PredictorWorkloadBalancing workloadBalancingConfig) {
        this.workloadBalancingConfig = workloadBalancingConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePredictorRequest createPredictorRequest = (CreatePredictorRequest)o;
        return Objects.equals(this.queueIds, createPredictorRequest.queueIds) && Objects.equals(this.kpi, createPredictorRequest.kpi) && Objects.equals(this.routingTimeoutSeconds, createPredictorRequest.routingTimeoutSeconds) && Objects.equals(this.schedule, createPredictorRequest.schedule) && Objects.equals(this.workloadBalancingConfig, createPredictorRequest.workloadBalancingConfig);
    }

    public int hashCode() {
        return Objects.hash(this.queueIds, this.kpi, this.routingTimeoutSeconds, this.schedule, this.workloadBalancingConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePredictorRequest {\n");
        sb.append("    queueIds: ").append(this.toIndentedString(this.queueIds)).append("\n");
        sb.append("    kpi: ").append(this.toIndentedString(this.kpi)).append("\n");
        sb.append("    routingTimeoutSeconds: ").append(this.toIndentedString(this.routingTimeoutSeconds)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    workloadBalancingConfig: ").append(this.toIndentedString(this.workloadBalancingConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

