/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CreateAlternativeShiftTradeRequest
implements Serializable {
    private String jobId = null;
    private List<String> dropShiftReferenceKeys = null;
    private List<String> pickupShiftReferenceKeys = null;
    private AlternativeShiftTradeGranularityEnum alternativeShiftTradeGranularity = null;
    private Date expirationDate = null;

    public CreateAlternativeShiftTradeRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.dropShiftReferenceKeys = new ArrayList<String>();
            this.pickupShiftReferenceKeys = new ArrayList<String>();
        }
    }

    public CreateAlternativeShiftTradeRequest jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of this alternative shift job")
    @JsonProperty(value="jobId")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public CreateAlternativeShiftTradeRequest dropShiftReferenceKeys(List<String> dropShiftReferenceKeys) {
        this.dropShiftReferenceKeys = dropShiftReferenceKeys;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of offered shift reference keys an agent wants to drop")
    @JsonProperty(value="dropShiftReferenceKeys")
    public List<String> getDropShiftReferenceKeys() {
        return this.dropShiftReferenceKeys;
    }

    public void setDropShiftReferenceKeys(List<String> dropShiftReferenceKeys) {
        this.dropShiftReferenceKeys = dropShiftReferenceKeys;
    }

    public CreateAlternativeShiftTradeRequest pickupShiftReferenceKeys(List<String> pickupShiftReferenceKeys) {
        this.pickupShiftReferenceKeys = pickupShiftReferenceKeys;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of offered shift reference keys an agent wants to pick up")
    @JsonProperty(value="pickupShiftReferenceKeys")
    public List<String> getPickupShiftReferenceKeys() {
        return this.pickupShiftReferenceKeys;
    }

    public void setPickupShiftReferenceKeys(List<String> pickupShiftReferenceKeys) {
        this.pickupShiftReferenceKeys = pickupShiftReferenceKeys;
    }

    public CreateAlternativeShiftTradeRequest alternativeShiftTradeGranularity(AlternativeShiftTradeGranularityEnum alternativeShiftTradeGranularity) {
        this.alternativeShiftTradeGranularity = alternativeShiftTradeGranularity;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The granularity of alternative shifts to be traded")
    @JsonProperty(value="alternativeShiftTradeGranularity")
    public AlternativeShiftTradeGranularityEnum getAlternativeShiftTradeGranularity() {
        return this.alternativeShiftTradeGranularity;
    }

    public void setAlternativeShiftTradeGranularity(AlternativeShiftTradeGranularityEnum alternativeShiftTradeGranularity) {
        this.alternativeShiftTradeGranularity = alternativeShiftTradeGranularity;
    }

    public CreateAlternativeShiftTradeRequest expirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date when the trade will expire in ISO-8601 format. The trade cannot be approved after expiration")
    @JsonProperty(value="expirationDate")
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAlternativeShiftTradeRequest createAlternativeShiftTradeRequest = (CreateAlternativeShiftTradeRequest)o;
        return Objects.equals(this.jobId, createAlternativeShiftTradeRequest.jobId) && Objects.equals(this.dropShiftReferenceKeys, createAlternativeShiftTradeRequest.dropShiftReferenceKeys) && Objects.equals(this.pickupShiftReferenceKeys, createAlternativeShiftTradeRequest.pickupShiftReferenceKeys) && Objects.equals((Object)this.alternativeShiftTradeGranularity, (Object)createAlternativeShiftTradeRequest.alternativeShiftTradeGranularity) && Objects.equals(this.expirationDate, createAlternativeShiftTradeRequest.expirationDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.dropShiftReferenceKeys, this.pickupShiftReferenceKeys, this.alternativeShiftTradeGranularity, this.expirationDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAlternativeShiftTradeRequest {\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    dropShiftReferenceKeys: ").append(this.toIndentedString(this.dropShiftReferenceKeys)).append("\n");
        sb.append("    pickupShiftReferenceKeys: ").append(this.toIndentedString(this.pickupShiftReferenceKeys)).append("\n");
        sb.append("    alternativeShiftTradeGranularity: ").append(this.toIndentedString((Object)this.alternativeShiftTradeGranularity)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AlternativeShiftTradeGranularityEnumDeserializer.class)
    public static enum AlternativeShiftTradeGranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily");

        private String value;

        private AlternativeShiftTradeGranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlternativeShiftTradeGranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlternativeShiftTradeGranularityEnum value : AlternativeShiftTradeGranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlternativeShiftTradeGranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AlternativeShiftTradeGranularityEnumDeserializer
    extends StdDeserializer<AlternativeShiftTradeGranularityEnum> {
        public AlternativeShiftTradeGranularityEnumDeserializer() {
            super(AlternativeShiftTradeGranularityEnumDeserializer.class);
        }

        public AlternativeShiftTradeGranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AlternativeShiftTradeGranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

