/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ConsultTransferToExternalContact
implements Serializable {
    private SpeakToEnum speakTo = null;
    private String consultingUserId = null;
    private String contactId = null;
    private PhoneTypeEnum phoneType = null;

    public ConsultTransferToExternalContact() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ConsultTransferToExternalContact speakTo(SpeakToEnum speakTo) {
        this.speakTo = speakTo;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Determines to whom the initiating participant is requesting to speak. Defaults to DESTINATION")
    @JsonProperty(value="speakTo")
    public SpeakToEnum getSpeakTo() {
        return this.speakTo;
    }

    public void setSpeakTo(SpeakToEnum speakTo) {
        this.speakTo = speakTo;
    }

    public ConsultTransferToExternalContact consultingUserId(String consultingUserId) {
        this.consultingUserId = consultingUserId;
        return this;
    }

    @ApiModelProperty(example="null", value="The user ID of the person who wants to talk before completing the transfer. Could be the same of the context user ID")
    @JsonProperty(value="consultingUserId")
    public String getConsultingUserId() {
        return this.consultingUserId;
    }

    public void setConsultingUserId(String consultingUserId) {
        this.consultingUserId = consultingUserId;
    }

    public ConsultTransferToExternalContact contactId(String contactId) {
        this.contactId = contactId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The external contact id.")
    @JsonProperty(value="contactId")
    public String getContactId() {
        return this.contactId;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public ConsultTransferToExternalContact phoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The external contact phone type.")
    @JsonProperty(value="phoneType")
    public PhoneTypeEnum getPhoneType() {
        return this.phoneType;
    }

    public void setPhoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsultTransferToExternalContact consultTransferToExternalContact = (ConsultTransferToExternalContact)o;
        return Objects.equals((Object)this.speakTo, (Object)consultTransferToExternalContact.speakTo) && Objects.equals(this.consultingUserId, consultTransferToExternalContact.consultingUserId) && Objects.equals(this.contactId, consultTransferToExternalContact.contactId) && Objects.equals((Object)this.phoneType, (Object)consultTransferToExternalContact.phoneType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.speakTo, this.consultingUserId, this.contactId, this.phoneType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConsultTransferToExternalContact {\n");
        sb.append("    speakTo: ").append(this.toIndentedString((Object)this.speakTo)).append("\n");
        sb.append("    consultingUserId: ").append(this.toIndentedString(this.consultingUserId)).append("\n");
        sb.append("    contactId: ").append(this.toIndentedString(this.contactId)).append("\n");
        sb.append("    phoneType: ").append(this.toIndentedString((Object)this.phoneType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SpeakToEnumDeserializer.class)
    public static enum SpeakToEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DESTINATION("DESTINATION"),
        OBJECT("OBJECT"),
        BOTH("BOTH"),
        CONFERENCE("CONFERENCE");

        private String value;

        private SpeakToEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SpeakToEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SpeakToEnum value : SpeakToEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SpeakToEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=PhoneTypeEnumDeserializer.class)
    public static enum PhoneTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WORKPHONE("WorkPhone"),
        CELLPHONE("CellPhone"),
        HOMEPHONE("HomePhone"),
        OTHERPHONE("OtherPhone");

        private String value;

        private PhoneTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PhoneTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PhoneTypeEnum value : PhoneTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PhoneTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PhoneTypeEnumDeserializer
    extends StdDeserializer<PhoneTypeEnum> {
        public PhoneTypeEnumDeserializer() {
            super(PhoneTypeEnumDeserializer.class);
        }

        public PhoneTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PhoneTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SpeakToEnumDeserializer
    extends StdDeserializer<SpeakToEnum> {
        public SpeakToEnumDeserializer() {
            super(SpeakToEnumDeserializer.class);
        }

        public SpeakToEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SpeakToEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

