/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class CobrowseWebMessagingSession
implements Serializable {
    private String id = null;
    private String name = null;
    private String joinCode = null;
    private String websocketUrl = null;
    private Date dateOfferEnds = null;
    private CommunicationTypeEnum communicationType = null;
    private String selfUri = null;

    public CobrowseWebMessagingSession() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CobrowseWebMessagingSession name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Cobrowse session join code")
    @JsonProperty(value="joinCode")
    public String getJoinCode() {
        return this.joinCode;
    }

    @ApiModelProperty(example="null", value="WebSocket URL for the JS client")
    @JsonProperty(value="websocketUrl")
    public String getWebsocketUrl() {
        return this.websocketUrl;
    }

    @ApiModelProperty(example="null", value="Date when Cobrowse Offer Expires. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateOfferEnds")
    public Date getDateOfferEnds() {
        return this.dateOfferEnds;
    }

    @ApiModelProperty(example="null", value="CommunicationType for Cobrowse Session")
    @JsonProperty(value="communicationType")
    public CommunicationTypeEnum getCommunicationType() {
        return this.communicationType;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CobrowseWebMessagingSession cobrowseWebMessagingSession = (CobrowseWebMessagingSession)o;
        return Objects.equals(this.id, cobrowseWebMessagingSession.id) && Objects.equals(this.name, cobrowseWebMessagingSession.name) && Objects.equals(this.joinCode, cobrowseWebMessagingSession.joinCode) && Objects.equals(this.websocketUrl, cobrowseWebMessagingSession.websocketUrl) && Objects.equals(this.dateOfferEnds, cobrowseWebMessagingSession.dateOfferEnds) && Objects.equals((Object)this.communicationType, (Object)cobrowseWebMessagingSession.communicationType) && Objects.equals(this.selfUri, cobrowseWebMessagingSession.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.joinCode, this.websocketUrl, this.dateOfferEnds, this.communicationType, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CobrowseWebMessagingSession {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    joinCode: ").append(this.toIndentedString(this.joinCode)).append("\n");
        sb.append("    websocketUrl: ").append(this.toIndentedString(this.websocketUrl)).append("\n");
        sb.append("    dateOfferEnds: ").append(this.toIndentedString(this.dateOfferEnds)).append("\n");
        sb.append("    communicationType: ").append(this.toIndentedString((Object)this.communicationType)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CommunicationTypeEnumDeserializer.class)
    public static enum CommunicationTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("Call"),
        MESSAGE("Message"),
        UNKNOWN("Unknown");

        private String value;

        private CommunicationTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CommunicationTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CommunicationTypeEnum value : CommunicationTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CommunicationTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CommunicationTypeEnumDeserializer
    extends StdDeserializer<CommunicationTypeEnum> {
        public CommunicationTypeEnumDeserializer() {
            super(CommunicationTypeEnumDeserializer.class);
        }

        public CommunicationTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CommunicationTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

