/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ChatMessageUser;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ChatMessage
implements Serializable {
    private String body = null;
    private String id = null;
    private String to = null;
    private String from = null;
    private String utc = null;
    private String chat = null;
    private String message = null;
    private String type = null;
    private BodyTypeEnum bodyType = null;
    private String senderCommunicationId = null;
    private String participantPurpose = null;
    private ChatMessageUser user = null;

    public ChatMessage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ChatMessage body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(example="null", value="The message body")
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public ChatMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ChatMessage to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", value="The message recipient")
    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public ChatMessage from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", value="The message sender")
    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public ChatMessage utc(String utc) {
        this.utc = utc;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="utc")
    public String getUtc() {
        return this.utc;
    }

    public void setUtc(String utc) {
        this.utc = utc;
    }

    public ChatMessage chat(String chat) {
        this.chat = chat;
        return this;
    }

    @ApiModelProperty(example="null", value="The interaction id (if available)")
    @JsonProperty(value="chat")
    public String getChat() {
        return this.chat;
    }

    public void setChat(String chat) {
        this.chat = chat;
    }

    public ChatMessage message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="null", value="The message id")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ChatMessage type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ChatMessage bodyType(BodyTypeEnum bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the message body (v2 chats only)")
    @JsonProperty(value="bodyType")
    public BodyTypeEnum getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyTypeEnum bodyType) {
        this.bodyType = bodyType;
    }

    public ChatMessage senderCommunicationId(String senderCommunicationId) {
        this.senderCommunicationId = senderCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Communication of sender (v2 chats only)")
    @JsonProperty(value="senderCommunicationId")
    public String getSenderCommunicationId() {
        return this.senderCommunicationId;
    }

    public void setSenderCommunicationId(String senderCommunicationId) {
        this.senderCommunicationId = senderCommunicationId;
    }

    public ChatMessage participantPurpose(String participantPurpose) {
        this.participantPurpose = participantPurpose;
        return this;
    }

    @ApiModelProperty(example="null", value="Participant purpose of sender (v2 chats only)")
    @JsonProperty(value="participantPurpose")
    public String getParticipantPurpose() {
        return this.participantPurpose;
    }

    public void setParticipantPurpose(String participantPurpose) {
        this.participantPurpose = participantPurpose;
    }

    public ChatMessage user(ChatMessageUser user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The user information for the sender (if available)")
    @JsonProperty(value="user")
    public ChatMessageUser getUser() {
        return this.user;
    }

    public void setUser(ChatMessageUser user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatMessage chatMessage = (ChatMessage)o;
        return Objects.equals(this.body, chatMessage.body) && Objects.equals(this.id, chatMessage.id) && Objects.equals(this.to, chatMessage.to) && Objects.equals(this.from, chatMessage.from) && Objects.equals(this.utc, chatMessage.utc) && Objects.equals(this.chat, chatMessage.chat) && Objects.equals(this.message, chatMessage.message) && Objects.equals(this.type, chatMessage.type) && Objects.equals((Object)this.bodyType, (Object)chatMessage.bodyType) && Objects.equals(this.senderCommunicationId, chatMessage.senderCommunicationId) && Objects.equals(this.participantPurpose, chatMessage.participantPurpose) && Objects.equals(this.user, chatMessage.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.body, this.id, this.to, this.from, this.utc, this.chat, this.message, this.type, this.bodyType, this.senderCommunicationId, this.participantPurpose, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChatMessage {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    utc: ").append(this.toIndentedString(this.utc)).append("\n");
        sb.append("    chat: ").append(this.toIndentedString(this.chat)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    bodyType: ").append(this.toIndentedString((Object)this.bodyType)).append("\n");
        sb.append("    senderCommunicationId: ").append(this.toIndentedString(this.senderCommunicationId)).append("\n");
        sb.append("    participantPurpose: ").append(this.toIndentedString(this.participantPurpose)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=BodyTypeEnumDeserializer.class)
    public static enum BodyTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STANDARD("STANDARD"),
        ACTIVITY("ACTIVITY"),
        TYPING("TYPING"),
        NOTICE("NOTICE"),
        MEMBERJOIN("MEMBERJOIN"),
        MEMBERLEAVE("MEMBERLEAVE"),
        MEDIAREQUEST("MEDIAREQUEST");

        private String value;

        private BodyTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BodyTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BodyTypeEnum value : BodyTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BodyTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BodyTypeEnumDeserializer
    extends StdDeserializer<BodyTypeEnum> {
        public BodyTypeEnumDeserializer() {
            super(BodyTypeEnumDeserializer.class);
        }

        public BodyTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BodyTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

