/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

public class CampaignRuleParameters
implements Serializable {
    private OperatorEnum operator = null;
    private String value = null;
    private PriorityEnum priority = null;
    private DialingModeEnum dialingMode = null;
    private BigDecimal abandonRate = null;
    private Integer outboundLineCount = null;
    private Integer relativeWeight = null;
    private BigDecimal maxCallsPerAgent = null;
    private DomainEntityRef queue = null;
    private Integer messagesPerMinute = null;
    private Integer smsMessagesPerMinute = null;
    private Integer emailMessagesPerMinute = null;
    private DomainEntityRef smsContentTemplate = null;
    private DomainEntityRef emailContentTemplate = null;

    public CampaignRuleParameters() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CampaignRuleParameters operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="The operator for comparison. Required for a CampaignRuleCondition.")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public CampaignRuleParameters value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The value for comparison. Required for a CampaignRuleCondition.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public CampaignRuleParameters priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority to set a campaign to. Required for the 'setCampaignPriority' action.")
    @JsonProperty(value="priority")
    public PriorityEnum getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public CampaignRuleParameters dialingMode(DialingModeEnum dialingMode) {
        this.dialingMode = dialingMode;
        return this;
    }

    @ApiModelProperty(example="null", value="The dialing mode to set a campaign to. Required for the 'setCampaignDialingMode' action.")
    @JsonProperty(value="dialingMode")
    public DialingModeEnum getDialingMode() {
        return this.dialingMode;
    }

    public void setDialingMode(DialingModeEnum dialingMode) {
        this.dialingMode = dialingMode;
    }

    public CampaignRuleParameters abandonRate(BigDecimal abandonRate) {
        this.abandonRate = abandonRate;
        return this;
    }

    @ApiModelProperty(example="null", value="The abandon rate to set a campaign to. Required for the 'setCampaignAbandonRate' action.")
    @JsonProperty(value="abandonRate")
    public BigDecimal getAbandonRate() {
        return this.abandonRate;
    }

    public void setAbandonRate(BigDecimal abandonRate) {
        this.abandonRate = abandonRate;
    }

    public CampaignRuleParameters outboundLineCount(Integer outboundLineCount) {
        this.outboundLineCount = outboundLineCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The  number of outbound lines to set a campaign to. Required for the 'setCampaignNumberOfLines' action.")
    @JsonProperty(value="outboundLineCount")
    public Integer getOutboundLineCount() {
        return this.outboundLineCount;
    }

    public void setOutboundLineCount(Integer outboundLineCount) {
        this.outboundLineCount = outboundLineCount;
    }

    public CampaignRuleParameters relativeWeight(Integer relativeWeight) {
        this.relativeWeight = relativeWeight;
        return this;
    }

    @ApiModelProperty(example="null", value="The relative weight to set a campaign to. Required for the 'setCampaignWeight' action.")
    @JsonProperty(value="relativeWeight")
    public Integer getRelativeWeight() {
        return this.relativeWeight;
    }

    public void setRelativeWeight(Integer relativeWeight) {
        this.relativeWeight = relativeWeight;
    }

    public CampaignRuleParameters maxCallsPerAgent(BigDecimal maxCallsPerAgent) {
        this.maxCallsPerAgent = maxCallsPerAgent;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum number of calls per agent to set a campaign to. Required for the 'setCampaignMaxCallsPerAgent' action.")
    @JsonProperty(value="maxCallsPerAgent")
    public BigDecimal getMaxCallsPerAgent() {
        return this.maxCallsPerAgent;
    }

    public void setMaxCallsPerAgent(BigDecimal maxCallsPerAgent) {
        this.maxCallsPerAgent = maxCallsPerAgent;
    }

    public CampaignRuleParameters queue(DomainEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue a campaign to. Required for the 'changeCampaignQueue' action.")
    @JsonProperty(value="queue")
    public DomainEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(DomainEntityRef queue) {
        this.queue = queue;
    }

    public CampaignRuleParameters messagesPerMinute(Integer messagesPerMinute) {
        this.messagesPerMinute = messagesPerMinute;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of messages per minute to set a messaging campaign to.")
    @JsonProperty(value="messagesPerMinute")
    public Integer getMessagesPerMinute() {
        return this.messagesPerMinute;
    }

    public void setMessagesPerMinute(Integer messagesPerMinute) {
        this.messagesPerMinute = messagesPerMinute;
    }

    public CampaignRuleParameters smsMessagesPerMinute(Integer smsMessagesPerMinute) {
        this.smsMessagesPerMinute = smsMessagesPerMinute;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of messages per minute to set a SMS messaging campaign to.")
    @JsonProperty(value="smsMessagesPerMinute")
    public Integer getSmsMessagesPerMinute() {
        return this.smsMessagesPerMinute;
    }

    public void setSmsMessagesPerMinute(Integer smsMessagesPerMinute) {
        this.smsMessagesPerMinute = smsMessagesPerMinute;
    }

    public CampaignRuleParameters emailMessagesPerMinute(Integer emailMessagesPerMinute) {
        this.emailMessagesPerMinute = emailMessagesPerMinute;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of messages per minute to set a Email messaging campaign to.")
    @JsonProperty(value="emailMessagesPerMinute")
    public Integer getEmailMessagesPerMinute() {
        return this.emailMessagesPerMinute;
    }

    public void setEmailMessagesPerMinute(Integer emailMessagesPerMinute) {
        this.emailMessagesPerMinute = emailMessagesPerMinute;
    }

    public CampaignRuleParameters smsContentTemplate(DomainEntityRef smsContentTemplate) {
        this.smsContentTemplate = smsContentTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="The content template to set a SMS campaign to.")
    @JsonProperty(value="smsContentTemplate")
    public DomainEntityRef getSmsContentTemplate() {
        return this.smsContentTemplate;
    }

    public void setSmsContentTemplate(DomainEntityRef smsContentTemplate) {
        this.smsContentTemplate = smsContentTemplate;
    }

    public CampaignRuleParameters emailContentTemplate(DomainEntityRef emailContentTemplate) {
        this.emailContentTemplate = emailContentTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="The content template to set a Email campaign to.")
    @JsonProperty(value="emailContentTemplate")
    public DomainEntityRef getEmailContentTemplate() {
        return this.emailContentTemplate;
    }

    public void setEmailContentTemplate(DomainEntityRef emailContentTemplate) {
        this.emailContentTemplate = emailContentTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignRuleParameters campaignRuleParameters = (CampaignRuleParameters)o;
        return Objects.equals((Object)this.operator, (Object)campaignRuleParameters.operator) && Objects.equals(this.value, campaignRuleParameters.value) && Objects.equals((Object)this.priority, (Object)campaignRuleParameters.priority) && Objects.equals((Object)this.dialingMode, (Object)campaignRuleParameters.dialingMode) && Objects.equals(this.abandonRate, campaignRuleParameters.abandonRate) && Objects.equals(this.outboundLineCount, campaignRuleParameters.outboundLineCount) && Objects.equals(this.relativeWeight, campaignRuleParameters.relativeWeight) && Objects.equals(this.maxCallsPerAgent, campaignRuleParameters.maxCallsPerAgent) && Objects.equals(this.queue, campaignRuleParameters.queue) && Objects.equals(this.messagesPerMinute, campaignRuleParameters.messagesPerMinute) && Objects.equals(this.smsMessagesPerMinute, campaignRuleParameters.smsMessagesPerMinute) && Objects.equals(this.emailMessagesPerMinute, campaignRuleParameters.emailMessagesPerMinute) && Objects.equals(this.smsContentTemplate, campaignRuleParameters.smsContentTemplate) && Objects.equals(this.emailContentTemplate, campaignRuleParameters.emailContentTemplate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.value, this.priority, this.dialingMode, this.abandonRate, this.outboundLineCount, this.relativeWeight, this.maxCallsPerAgent, this.queue, this.messagesPerMinute, this.smsMessagesPerMinute, this.emailMessagesPerMinute, this.smsContentTemplate, this.emailContentTemplate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignRuleParameters {\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    dialingMode: ").append(this.toIndentedString((Object)this.dialingMode)).append("\n");
        sb.append("    abandonRate: ").append(this.toIndentedString(this.abandonRate)).append("\n");
        sb.append("    outboundLineCount: ").append(this.toIndentedString(this.outboundLineCount)).append("\n");
        sb.append("    relativeWeight: ").append(this.toIndentedString(this.relativeWeight)).append("\n");
        sb.append("    maxCallsPerAgent: ").append(this.toIndentedString(this.maxCallsPerAgent)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    messagesPerMinute: ").append(this.toIndentedString(this.messagesPerMinute)).append("\n");
        sb.append("    smsMessagesPerMinute: ").append(this.toIndentedString(this.smsMessagesPerMinute)).append("\n");
        sb.append("    emailMessagesPerMinute: ").append(this.toIndentedString(this.emailMessagesPerMinute)).append("\n");
        sb.append("    smsContentTemplate: ").append(this.toIndentedString(this.smsContentTemplate)).append("\n");
        sb.append("    emailContentTemplate: ").append(this.toIndentedString(this.emailContentTemplate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALS("equals"),
        GREATERTHAN("greaterThan"),
        GREATERTHANEQUALTO("greaterThanEqualTo"),
        LESSTHAN("lessThan"),
        LESSTHANEQUALTO("lessThanEqualTo"),
        BEFORE("before"),
        AFTER("after"),
        BETWEEN("between"),
        IN("in");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=PriorityEnumDeserializer.class)
    public static enum PriorityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        _1("1"),
        _2("2"),
        _3("3"),
        _4("4"),
        _5("5");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PriorityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PriorityEnum value : PriorityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PriorityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DialingModeEnumDeserializer.class)
    public static enum DialingModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENTLESS("agentless"),
        PREVIEW("preview"),
        POWER("power"),
        PREDICTIVE("predictive"),
        PROGRESSIVE("progressive"),
        EXTERNAL("external");

        private String value;

        private DialingModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DialingModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DialingModeEnum value : DialingModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DialingModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DialingModeEnumDeserializer
    extends StdDeserializer<DialingModeEnum> {
        public DialingModeEnumDeserializer() {
            super(DialingModeEnumDeserializer.class);
        }

        public DialingModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DialingModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class PriorityEnumDeserializer
    extends StdDeserializer<PriorityEnum> {
        public PriorityEnumDeserializer() {
            super(PriorityEnumDeserializer.class);
        }

        public PriorityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PriorityEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

