/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class Attachment
implements Serializable {
    private String attachmentId = null;
    private String name = null;
    private String contentUri = null;
    private String contentType = null;
    private Integer contentLength = null;
    private Boolean inlineImage = null;

    public Attachment() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public Attachment attachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier for the attachment.")
    @JsonProperty(value="attachmentId")
    public String getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public Attachment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the attachment.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Attachment contentUri(String contentUri) {
        this.contentUri = contentUri;
        return this;
    }

    @ApiModelProperty(example="null", value="The content uri of the attachment. If set, this is commonly a public api download location.")
    @JsonProperty(value="contentUri")
    public String getContentUri() {
        return this.contentUri;
    }

    public void setContentUri(String contentUri) {
        this.contentUri = contentUri;
    }

    public Attachment contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of file the attachment is.")
    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Attachment contentLength(Integer contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    @ApiModelProperty(example="null", value="The length of the attachment file.")
    @JsonProperty(value="contentLength")
    public Integer getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Integer contentLength) {
        this.contentLength = contentLength;
    }

    public Attachment inlineImage(Boolean inlineImage) {
        this.inlineImage = inlineImage;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not the attachment was attached inline.,")
    @JsonProperty(value="inlineImage")
    public Boolean getInlineImage() {
        return this.inlineImage;
    }

    public void setInlineImage(Boolean inlineImage) {
        this.inlineImage = inlineImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment attachment = (Attachment)o;
        return Objects.equals(this.attachmentId, attachment.attachmentId) && Objects.equals(this.name, attachment.name) && Objects.equals(this.contentUri, attachment.contentUri) && Objects.equals(this.contentType, attachment.contentType) && Objects.equals(this.contentLength, attachment.contentLength) && Objects.equals(this.inlineImage, attachment.inlineImage);
    }

    public int hashCode() {
        return Objects.hash(this.attachmentId, this.name, this.contentUri, this.contentType, this.contentLength, this.inlineImage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attachment {\n");
        sb.append("    attachmentId: ").append(this.toIndentedString(this.attachmentId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    contentUri: ").append(this.toIndentedString(this.contentUri)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    contentLength: ").append(this.toIndentedString(this.contentLength)).append("\n");
        sb.append("    inlineImage: ").append(this.toIndentedString(this.inlineImage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

