/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AcceleratorParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Identity of a CX infrastructure as code accelerator to be run and its inputs")
public class AcceleratorInput
implements Serializable {
    private Boolean dryRun = null;
    private String acceleratorId = null;
    private List<AcceleratorParameter> parameters = null;

    public AcceleratorInput() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.parameters = new ArrayList<AcceleratorParameter>();
        }
    }

    public AcceleratorInput dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @ApiModelProperty(example="null", value="Set this true to test the job without making any changes. Defaults to false.")
    @JsonProperty(value="dryRun")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public AcceleratorInput acceleratorId(String acceleratorId) {
        this.acceleratorId = acceleratorId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Accelerator ID")
    @JsonProperty(value="acceleratorId")
    public String getAcceleratorId() {
        return this.acceleratorId;
    }

    public void setAcceleratorId(String acceleratorId) {
        this.acceleratorId = acceleratorId;
    }

    public AcceleratorInput parameters(List<AcceleratorParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @ApiModelProperty(example="null", value="Parameters required for this accelerator")
    @JsonProperty(value="parameters")
    public List<AcceleratorParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<AcceleratorParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceleratorInput acceleratorInput = (AcceleratorInput)o;
        return Objects.equals(this.dryRun, acceleratorInput.dryRun) && Objects.equals(this.acceleratorId, acceleratorInput.acceleratorId) && Objects.equals(this.parameters, acceleratorInput.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.dryRun, this.acceleratorId, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcceleratorInput {\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    acceleratorId: ").append(this.toIndentedString(this.acceleratorId)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

