/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteUserrecordingRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserrecordingRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserrecordingTranscodingRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserrecordingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserrecordingsSummaryRequest;
import com.mypurecloud.sdk.v2.api.request.PutUserrecordingRequest;
import com.mypurecloud.sdk.v2.model.DownloadResponse;
import com.mypurecloud.sdk.v2.model.FaxSummary;
import com.mypurecloud.sdk.v2.model.UserRecording;
import com.mypurecloud.sdk.v2.model.UserRecordingEntityListing;
import java.io.IOException;
import java.util.List;

public class UserRecordingsApi {
    private final ApiClient pcapiClient;

    public UserRecordingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserRecordingsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteUserrecording(String recordingId) throws IOException, ApiException {
        this.deleteUserrecording(this.createDeleteUserrecordingRequest(recordingId));
    }

    public ApiResponse<Void> deleteUserrecordingWithHttpInfo(String recordingId) throws IOException {
        return this.deleteUserrecording(this.createDeleteUserrecordingRequest(recordingId).withHttpInfo());
    }

    private DeleteUserrecordingRequest createDeleteUserrecordingRequest(String recordingId) {
        return DeleteUserrecordingRequest.builder().withRecordingId(recordingId).build();
    }

    public void deleteUserrecording(DeleteUserrecordingRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteUserrecording(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserRecording getUserrecording(String recordingId, List<String> expand) throws IOException, ApiException {
        return this.getUserrecording(this.createGetUserrecordingRequest(recordingId, expand));
    }

    public ApiResponse<UserRecording> getUserrecordingWithHttpInfo(String recordingId, List<String> expand) throws IOException {
        return this.getUserrecording(this.createGetUserrecordingRequest(recordingId, expand).withHttpInfo());
    }

    private GetUserrecordingRequest createGetUserrecordingRequest(String recordingId, List<String> expand) {
        return GetUserrecordingRequest.builder().withRecordingId(recordingId).withExpand(expand).build();
    }

    public UserRecording getUserrecording(GetUserrecordingRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserRecording> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserRecording>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserRecording> getUserrecording(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserRecording>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DownloadResponse getUserrecordingTranscoding(String recordingId, String formatId) throws IOException, ApiException {
        return this.getUserrecordingTranscoding(this.createGetUserrecordingTranscodingRequest(recordingId, formatId));
    }

    public ApiResponse<DownloadResponse> getUserrecordingTranscodingWithHttpInfo(String recordingId, String formatId) throws IOException {
        return this.getUserrecordingTranscoding(this.createGetUserrecordingTranscodingRequest(recordingId, formatId).withHttpInfo());
    }

    private GetUserrecordingTranscodingRequest createGetUserrecordingTranscodingRequest(String recordingId, String formatId) {
        return GetUserrecordingTranscodingRequest.builder().withRecordingId(recordingId).withFormatId(formatId).build();
    }

    public DownloadResponse getUserrecordingTranscoding(GetUserrecordingTranscodingRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DownloadResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DownloadResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DownloadResponse> getUserrecordingTranscoding(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DownloadResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserRecordingEntityListing getUserrecordings(Integer pageSize, Integer pageNumber, List<String> expand) throws IOException, ApiException {
        return this.getUserrecordings(this.createGetUserrecordingsRequest(pageSize, pageNumber, expand));
    }

    public ApiResponse<UserRecordingEntityListing> getUserrecordingsWithHttpInfo(Integer pageSize, Integer pageNumber, List<String> expand) throws IOException {
        return this.getUserrecordings(this.createGetUserrecordingsRequest(pageSize, pageNumber, expand).withHttpInfo());
    }

    private GetUserrecordingsRequest createGetUserrecordingsRequest(Integer pageSize, Integer pageNumber, List<String> expand) {
        return GetUserrecordingsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withExpand(expand).build();
    }

    public UserRecordingEntityListing getUserrecordings(GetUserrecordingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserRecordingEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserRecordingEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserRecordingEntityListing> getUserrecordings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserRecordingEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public FaxSummary getUserrecordingsSummary() throws IOException, ApiException {
        return this.getUserrecordingsSummary(this.createGetUserrecordingsSummaryRequest());
    }

    public ApiResponse<FaxSummary> getUserrecordingsSummaryWithHttpInfo() throws IOException {
        return this.getUserrecordingsSummary(this.createGetUserrecordingsSummaryRequest().withHttpInfo());
    }

    private GetUserrecordingsSummaryRequest createGetUserrecordingsSummaryRequest() {
        return GetUserrecordingsSummaryRequest.builder().build();
    }

    public FaxSummary getUserrecordingsSummary(GetUserrecordingsSummaryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<FaxSummary> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<FaxSummary>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<FaxSummary> getUserrecordingsSummary(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<FaxSummary>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserRecording putUserrecording(String recordingId, UserRecording body, List<String> expand) throws IOException, ApiException {
        return this.putUserrecording(this.createPutUserrecordingRequest(recordingId, body, expand));
    }

    public ApiResponse<UserRecording> putUserrecordingWithHttpInfo(String recordingId, UserRecording body, List<String> expand) throws IOException {
        return this.putUserrecording(this.createPutUserrecordingRequest(recordingId, body, expand).withHttpInfo());
    }

    private PutUserrecordingRequest createPutUserrecordingRequest(String recordingId, UserRecording body, List<String> expand) {
        return PutUserrecordingRequest.builder().withRecordingId(recordingId).withBody(body).withExpand(expand).build();
    }

    public UserRecording putUserrecording(PutUserrecordingRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserRecording> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserRecording>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserRecording> putUserrecording(ApiRequest<UserRecording> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserRecording>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

