/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BuShortTermForecastWeekReference;
import com.mypurecloud.sdk.v2.model.WorkPlanBidMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Work plan bid response")
public class WorkPlanBid
implements Serializable {
    private String id = null;
    private String name = null;
    private BuShortTermForecastWeekReference forecast = null;
    private LocalDate bidWindowStartDate = null;
    private LocalDate bidWindowEndDate = null;
    private LocalDate effectiveDate = null;
    private StatusEnum status = null;
    private AgentRankingTypeEnum agentRankingType = null;
    private RankingTiebreakerTypeEnum rankingTiebreakerType = null;
    private Date publishedDate = null;
    private List<WorkPlanFieldsVisibleToAgentsEnum> workPlanFieldsVisibleToAgents = null;
    private WorkPlanBidMetadata metadata = null;
    private String selfUri = null;

    public WorkPlanBid() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.workPlanFieldsVisibleToAgents = new ArrayList<WorkPlanFieldsVisibleToAgentsEnum>();
        }
    }

    public WorkPlanBid id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the work plan bid")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkPlanBid name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the work plan bid")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkPlanBid forecast(BuShortTermForecastWeekReference forecast) {
        this.forecast = forecast;
        return this;
    }

    @ApiModelProperty(example="null", value="The selected forecast in this work plan bid")
    @JsonProperty(value="forecast")
    public BuShortTermForecastWeekReference getForecast() {
        return this.forecast;
    }

    public void setForecast(BuShortTermForecastWeekReference forecast) {
        this.forecast = forecast;
    }

    public WorkPlanBid bidWindowStartDate(LocalDate bidWindowStartDate) {
        this.bidWindowStartDate = bidWindowStartDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The bid start date where agents start participate in work plan bidding. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="bidWindowStartDate")
    public LocalDate getBidWindowStartDate() {
        return this.bidWindowStartDate;
    }

    public void setBidWindowStartDate(LocalDate bidWindowStartDate) {
        this.bidWindowStartDate = bidWindowStartDate;
    }

    public WorkPlanBid bidWindowEndDate(LocalDate bidWindowEndDate) {
        this.bidWindowEndDate = bidWindowEndDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The bid end date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="bidWindowEndDate")
    public LocalDate getBidWindowEndDate() {
        return this.bidWindowEndDate;
    }

    public void setBidWindowEndDate(LocalDate bidWindowEndDate) {
        this.bidWindowEndDate = bidWindowEndDate;
    }

    public WorkPlanBid effectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date when agents will be assigned to the new work plan. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="effectiveDate")
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public WorkPlanBid status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of the bid")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public WorkPlanBid agentRankingType(AgentRankingTypeEnum agentRankingType) {
        this.agentRankingType = agentRankingType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of agent ranking selected for this bid")
    @JsonProperty(value="agentRankingType")
    public AgentRankingTypeEnum getAgentRankingType() {
        return this.agentRankingType;
    }

    public void setAgentRankingType(AgentRankingTypeEnum agentRankingType) {
        this.agentRankingType = agentRankingType;
    }

    public WorkPlanBid rankingTiebreakerType(RankingTiebreakerTypeEnum rankingTiebreakerType) {
        this.rankingTiebreakerType = rankingTiebreakerType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Ranking tiebreaker")
    @JsonProperty(value="rankingTiebreakerType")
    public RankingTiebreakerTypeEnum getRankingTiebreakerType() {
        return this.rankingTiebreakerType;
    }

    public void setRankingTiebreakerType(RankingTiebreakerTypeEnum rankingTiebreakerType) {
        this.rankingTiebreakerType = rankingTiebreakerType;
    }

    public WorkPlanBid publishedDate(Date publishedDate) {
        this.publishedDate = publishedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the work plan bid published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="publishedDate")
    public Date getPublishedDate() {
        return this.publishedDate;
    }

    public void setPublishedDate(Date publishedDate) {
        this.publishedDate = publishedDate;
    }

    public WorkPlanBid workPlanFieldsVisibleToAgents(List<WorkPlanFieldsVisibleToAgentsEnum> workPlanFieldsVisibleToAgents) {
        this.workPlanFieldsVisibleToAgents = workPlanFieldsVisibleToAgents;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The work plan fields visible to agents whenever work plan preferences are made")
    @JsonProperty(value="workPlanFieldsVisibleToAgents")
    public List<WorkPlanFieldsVisibleToAgentsEnum> getWorkPlanFieldsVisibleToAgents() {
        return this.workPlanFieldsVisibleToAgents;
    }

    public void setWorkPlanFieldsVisibleToAgents(List<WorkPlanFieldsVisibleToAgentsEnum> workPlanFieldsVisibleToAgents) {
        this.workPlanFieldsVisibleToAgents = workPlanFieldsVisibleToAgents;
    }

    public WorkPlanBid metadata(WorkPlanBidMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="The meta data of this bid")
    @JsonProperty(value="metadata")
    public WorkPlanBidMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WorkPlanBidMetadata metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkPlanBid workPlanBid = (WorkPlanBid)o;
        return Objects.equals(this.id, workPlanBid.id) && Objects.equals(this.name, workPlanBid.name) && Objects.equals(this.forecast, workPlanBid.forecast) && Objects.equals(this.bidWindowStartDate, workPlanBid.bidWindowStartDate) && Objects.equals(this.bidWindowEndDate, workPlanBid.bidWindowEndDate) && Objects.equals(this.effectiveDate, workPlanBid.effectiveDate) && Objects.equals((Object)this.status, (Object)workPlanBid.status) && Objects.equals((Object)this.agentRankingType, (Object)workPlanBid.agentRankingType) && Objects.equals((Object)this.rankingTiebreakerType, (Object)workPlanBid.rankingTiebreakerType) && Objects.equals(this.publishedDate, workPlanBid.publishedDate) && Objects.equals(this.workPlanFieldsVisibleToAgents, workPlanBid.workPlanFieldsVisibleToAgents) && Objects.equals(this.metadata, workPlanBid.metadata) && Objects.equals(this.selfUri, workPlanBid.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.forecast, this.bidWindowStartDate, this.bidWindowEndDate, this.effectiveDate, this.status, this.agentRankingType, this.rankingTiebreakerType, this.publishedDate, this.workPlanFieldsVisibleToAgents, this.metadata, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkPlanBid {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    forecast: ").append(this.toIndentedString(this.forecast)).append("\n");
        sb.append("    bidWindowStartDate: ").append(this.toIndentedString(this.bidWindowStartDate)).append("\n");
        sb.append("    bidWindowEndDate: ").append(this.toIndentedString(this.bidWindowEndDate)).append("\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    agentRankingType: ").append(this.toIndentedString((Object)this.agentRankingType)).append("\n");
        sb.append("    rankingTiebreakerType: ").append(this.toIndentedString((Object)this.rankingTiebreakerType)).append("\n");
        sb.append("    publishedDate: ").append(this.toIndentedString(this.publishedDate)).append("\n");
        sb.append("    workPlanFieldsVisibleToAgents: ").append(this.toIndentedString(this.workPlanFieldsVisibleToAgents)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DRAFT("Draft"),
        LOCKED("Locked"),
        OPTIMIZED("Optimized"),
        SCHEDULED("Scheduled"),
        OPEN("Open"),
        CLOSED("Closed"),
        PROCESSED("Processed"),
        PUBLISHED("Published");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=AgentRankingTypeEnumDeserializer.class)
    public static enum AgentRankingTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HIREDATE("HireDate"),
        PERFORMANCE("Performance");

        private String value;

        private AgentRankingTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AgentRankingTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AgentRankingTypeEnum value : AgentRankingTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AgentRankingTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=RankingTiebreakerTypeEnumDeserializer.class)
    public static enum RankingTiebreakerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HIREDATE("HireDate"),
        PERFORMANCE("Performance"),
        CUSTOM("Custom"),
        RANDOMLYASSIGN("RandomlyAssign");

        private String value;

        private RankingTiebreakerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RankingTiebreakerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RankingTiebreakerTypeEnum value : RankingTiebreakerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RankingTiebreakerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=WorkPlanFieldsVisibleToAgentsEnumDeserializer.class)
    public static enum WorkPlanFieldsVisibleToAgentsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NAME("Name"),
        PAIDHOURS("PaidHours");

        private String value;

        private WorkPlanFieldsVisibleToAgentsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static WorkPlanFieldsVisibleToAgentsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (WorkPlanFieldsVisibleToAgentsEnum value : WorkPlanFieldsVisibleToAgentsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return WorkPlanFieldsVisibleToAgentsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class WorkPlanFieldsVisibleToAgentsEnumDeserializer
    extends StdDeserializer<WorkPlanFieldsVisibleToAgentsEnum> {
        public WorkPlanFieldsVisibleToAgentsEnumDeserializer() {
            super(WorkPlanFieldsVisibleToAgentsEnumDeserializer.class);
        }

        public WorkPlanFieldsVisibleToAgentsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return WorkPlanFieldsVisibleToAgentsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class RankingTiebreakerTypeEnumDeserializer
    extends StdDeserializer<RankingTiebreakerTypeEnum> {
        public RankingTiebreakerTypeEnumDeserializer() {
            super(RankingTiebreakerTypeEnumDeserializer.class);
        }

        public RankingTiebreakerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RankingTiebreakerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class AgentRankingTypeEnumDeserializer
    extends StdDeserializer<AgentRankingTypeEnum> {
        public AgentRankingTypeEnumDeserializer() {
            super(AgentRankingTypeEnumDeserializer.class);
        }

        public AgentRankingTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AgentRankingTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

