/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.UserScheduleFullDayTimeOffMarker;
import com.mypurecloud.sdk.v2.model.UserScheduleShift;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserSchedule
implements Serializable {
    private List<UserScheduleShift> shifts = null;
    private List<UserScheduleFullDayTimeOffMarker> fullDayTimeOffMarkers = null;
    private Boolean delete = null;
    private WfmVersionedEntityMetadata metadata = null;
    private String workPlanId = null;

    public UserSchedule() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.shifts = new ArrayList<UserScheduleShift>();
            this.fullDayTimeOffMarkers = new ArrayList<UserScheduleFullDayTimeOffMarker>();
        }
    }

    public UserSchedule shifts(List<UserScheduleShift> shifts) {
        this.shifts = shifts;
        return this;
    }

    @ApiModelProperty(example="null", value="The shifts that belong to this schedule")
    @JsonProperty(value="shifts")
    public List<UserScheduleShift> getShifts() {
        return this.shifts;
    }

    public void setShifts(List<UserScheduleShift> shifts) {
        this.shifts = shifts;
    }

    public UserSchedule fullDayTimeOffMarkers(List<UserScheduleFullDayTimeOffMarker> fullDayTimeOffMarkers) {
        this.fullDayTimeOffMarkers = fullDayTimeOffMarkers;
        return this;
    }

    @ApiModelProperty(example="null", value="Markers to indicate a full day time off request, relative to the management unit time zone")
    @JsonProperty(value="fullDayTimeOffMarkers")
    public List<UserScheduleFullDayTimeOffMarker> getFullDayTimeOffMarkers() {
        return this.fullDayTimeOffMarkers;
    }

    public void setFullDayTimeOffMarkers(List<UserScheduleFullDayTimeOffMarker> fullDayTimeOffMarkers) {
        this.fullDayTimeOffMarkers = fullDayTimeOffMarkers;
    }

    public UserSchedule delete(Boolean delete) {
        this.delete = delete;
        return this;
    }

    @ApiModelProperty(example="null", value="If marked true for updating an existing user schedule, it will be deleted")
    @JsonProperty(value="delete")
    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public UserSchedule metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for this schedule")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="ID of the work plan associated with the user during schedule creation")
    @JsonProperty(value="workPlanId")
    public String getWorkPlanId() {
        return this.workPlanId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSchedule userSchedule = (UserSchedule)o;
        return Objects.equals(this.shifts, userSchedule.shifts) && Objects.equals(this.fullDayTimeOffMarkers, userSchedule.fullDayTimeOffMarkers) && Objects.equals(this.delete, userSchedule.delete) && Objects.equals(this.metadata, userSchedule.metadata) && Objects.equals(this.workPlanId, userSchedule.workPlanId);
    }

    public int hashCode() {
        return Objects.hash(this.shifts, this.fullDayTimeOffMarkers, this.delete, this.metadata, this.workPlanId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSchedule {\n");
        sb.append("    shifts: ").append(this.toIndentedString(this.shifts)).append("\n");
        sb.append("    fullDayTimeOffMarkers: ").append(this.toIndentedString(this.fullDayTimeOffMarkers)).append("\n");
        sb.append("    delete: ").append(this.toIndentedString(this.delete)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    workPlanId: ").append(this.toIndentedString(this.workPlanId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

