/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ActionMapActionTemplate;
import com.mypurecloud.sdk.v2.model.ArchitectFlowFields;
import com.mypurecloud.sdk.v2.model.OpenActionFields;
import com.mypurecloud.sdk.v2.model.PatchActionProperties;
import com.mypurecloud.sdk.v2.model.PatchWebMessagingOfferFields;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class PatchAction
implements Serializable {
    private MediaTypeEnum mediaType = null;
    private ActionMapActionTemplate actionTemplate = null;
    private String actionTargetId = null;
    private Boolean isPacingEnabled = null;
    private PatchActionProperties props = null;
    private ArchitectFlowFields architectFlowFields = null;
    private PatchWebMessagingOfferFields webMessagingOfferFields = null;
    private OpenActionFields openActionFields = null;

    public PatchAction() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public PatchAction mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Media type of action.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public PatchAction actionTemplate(ActionMapActionTemplate actionTemplate) {
        this.actionTemplate = actionTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="Action template associated with the action map.")
    @JsonProperty(value="actionTemplate")
    public ActionMapActionTemplate getActionTemplate() {
        return this.actionTemplate;
    }

    public void setActionTemplate(ActionMapActionTemplate actionTemplate) {
        this.actionTemplate = actionTemplate;
    }

    public PatchAction actionTargetId(String actionTargetId) {
        this.actionTargetId = actionTargetId;
        return this;
    }

    @ApiModelProperty(example="null", value="Action target ID.")
    @JsonProperty(value="actionTargetId")
    public String getActionTargetId() {
        return this.actionTargetId;
    }

    public void setActionTargetId(String actionTargetId) {
        this.actionTargetId = actionTargetId;
    }

    public PatchAction isPacingEnabled(Boolean isPacingEnabled) {
        this.isPacingEnabled = isPacingEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this action should be throttled.")
    @JsonProperty(value="isPacingEnabled")
    public Boolean getIsPacingEnabled() {
        return this.isPacingEnabled;
    }

    public void setIsPacingEnabled(Boolean isPacingEnabled) {
        this.isPacingEnabled = isPacingEnabled;
    }

    public PatchAction props(PatchActionProperties props) {
        this.props = props;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional properties.")
    @JsonProperty(value="props")
    public PatchActionProperties getProps() {
        return this.props;
    }

    public void setProps(PatchActionProperties props) {
        this.props = props;
    }

    public PatchAction architectFlowFields(ArchitectFlowFields architectFlowFields) {
        this.architectFlowFields = architectFlowFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Architect Flow Id and input contract.")
    @JsonProperty(value="architectFlowFields")
    public ArchitectFlowFields getArchitectFlowFields() {
        return this.architectFlowFields;
    }

    public void setArchitectFlowFields(ArchitectFlowFields architectFlowFields) {
        this.architectFlowFields = architectFlowFields;
    }

    public PatchAction webMessagingOfferFields(PatchWebMessagingOfferFields webMessagingOfferFields) {
        this.webMessagingOfferFields = webMessagingOfferFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Admin-configurable fields of a web messaging offer action.")
    @JsonProperty(value="webMessagingOfferFields")
    public PatchWebMessagingOfferFields getWebMessagingOfferFields() {
        return this.webMessagingOfferFields;
    }

    public void setWebMessagingOfferFields(PatchWebMessagingOfferFields webMessagingOfferFields) {
        this.webMessagingOfferFields = webMessagingOfferFields;
    }

    public PatchAction openActionFields(OpenActionFields openActionFields) {
        this.openActionFields = openActionFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Admin-configurable fields of an open action.")
    @JsonProperty(value="openActionFields")
    public OpenActionFields getOpenActionFields() {
        return this.openActionFields;
    }

    public void setOpenActionFields(OpenActionFields openActionFields) {
        this.openActionFields = openActionFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchAction patchAction = (PatchAction)o;
        return Objects.equals((Object)this.mediaType, (Object)patchAction.mediaType) && Objects.equals(this.actionTemplate, patchAction.actionTemplate) && Objects.equals(this.actionTargetId, patchAction.actionTargetId) && Objects.equals(this.isPacingEnabled, patchAction.isPacingEnabled) && Objects.equals(this.props, patchAction.props) && Objects.equals(this.architectFlowFields, patchAction.architectFlowFields) && Objects.equals(this.webMessagingOfferFields, patchAction.webMessagingOfferFields) && Objects.equals(this.openActionFields, patchAction.openActionFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mediaType, this.actionTemplate, this.actionTargetId, this.isPacingEnabled, this.props, this.architectFlowFields, this.webMessagingOfferFields, this.openActionFields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchAction {\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    actionTemplate: ").append(this.toIndentedString(this.actionTemplate)).append("\n");
        sb.append("    actionTargetId: ").append(this.toIndentedString(this.actionTargetId)).append("\n");
        sb.append("    isPacingEnabled: ").append(this.toIndentedString(this.isPacingEnabled)).append("\n");
        sb.append("    props: ").append(this.toIndentedString(this.props)).append("\n");
        sb.append("    architectFlowFields: ").append(this.toIndentedString(this.architectFlowFields)).append("\n");
        sb.append("    webMessagingOfferFields: ").append(this.toIndentedString(this.webMessagingOfferFields)).append("\n");
        sb.append("    openActionFields: ").append(this.toIndentedString(this.openActionFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WEBCHAT("webchat"),
        WEBMESSAGINGOFFER("webMessagingOffer"),
        CONTENTOFFER("contentOffer"),
        INTEGRATIONACTION("integrationAction"),
        ARCHITECTFLOW("architectFlow"),
        OPENACTION("openAction");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

