/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MetadataProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="A description of the contents of a data gathering interface for an accelerator")
public class MetadataSchema
implements Serializable {
    private String title = null;
    private String description = null;
    private String type = null;
    private List<Map<String, MetadataProperty>> properties = null;
    private List<String> required = null;

    public MetadataSchema() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.properties = new ArrayList<Map<String, MetadataProperty>>();
            this.required = new ArrayList<String>();
        }
    }

    @ApiModelProperty(example="null", value="title for the data gathering page")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @ApiModelProperty(example="null", value="description of the data being gathered on this page")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="type of data being gathered")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @ApiModelProperty(example="null", value="list of properties for which input is to be gathered, bother required and optional")
    @JsonProperty(value="properties")
    public List<Map<String, MetadataProperty>> getProperties() {
        return this.properties;
    }

    @ApiModelProperty(example="null", value="list of required properties")
    @JsonProperty(value="required")
    public List<String> getRequired() {
        return this.required;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataSchema metadataSchema = (MetadataSchema)o;
        return Objects.equals(this.title, metadataSchema.title) && Objects.equals(this.description, metadataSchema.description) && Objects.equals(this.type, metadataSchema.type) && Objects.equals(this.properties, metadataSchema.properties) && Objects.equals(this.required, metadataSchema.required);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.type, this.properties, this.required);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataSchema {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

