/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WrapupInput;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class MediaParticipantRequest
implements Serializable {
    private WrapupInput wrapup = null;
    private StateEnum state = null;
    private Boolean recording = null;
    private Boolean muted = null;
    private Boolean confined = null;
    private Boolean held = null;
    private Boolean wrapupSkipped = null;

    public MediaParticipantRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public MediaParticipantRequest wrapup(WrapupInput wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Wrap-up to assign to this participant.")
    @JsonProperty(value="wrapup")
    public WrapupInput getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(WrapupInput wrapup) {
        this.wrapup = wrapup;
    }

    public MediaParticipantRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state to update to set for this participant's communications.  Possible values are: 'connected' and 'disconnected'.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public MediaParticipantRequest recording(Boolean recording) {
        this.recording = recording;
        return this;
    }

    @ApiModelProperty(example="null", value="True to enable recording of this participant, otherwise false to disable recording.")
    @JsonProperty(value="recording")
    public Boolean getRecording() {
        return this.recording;
    }

    public void setRecording(Boolean recording) {
        this.recording = recording;
    }

    public MediaParticipantRequest muted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    @ApiModelProperty(example="null", value="True to mute this conversation participant.")
    @JsonProperty(value="muted")
    public Boolean getMuted() {
        return this.muted;
    }

    public void setMuted(Boolean muted) {
        this.muted = muted;
    }

    public MediaParticipantRequest confined(Boolean confined) {
        this.confined = confined;
        return this;
    }

    @ApiModelProperty(example="null", value="True to confine this conversation participant.  Should only be used for ad-hoc conferences")
    @JsonProperty(value="confined")
    public Boolean getConfined() {
        return this.confined;
    }

    public void setConfined(Boolean confined) {
        this.confined = confined;
    }

    public MediaParticipantRequest held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="True to hold this conversation participant.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public MediaParticipantRequest wrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
        return this;
    }

    @ApiModelProperty(example="null", value="True to skip wrap-up for this participant.")
    @JsonProperty(value="wrapupSkipped")
    public Boolean getWrapupSkipped() {
        return this.wrapupSkipped;
    }

    public void setWrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaParticipantRequest mediaParticipantRequest = (MediaParticipantRequest)o;
        return Objects.equals(this.wrapup, mediaParticipantRequest.wrapup) && Objects.equals((Object)this.state, (Object)mediaParticipantRequest.state) && Objects.equals(this.recording, mediaParticipantRequest.recording) && Objects.equals(this.muted, mediaParticipantRequest.muted) && Objects.equals(this.confined, mediaParticipantRequest.confined) && Objects.equals(this.held, mediaParticipantRequest.held) && Objects.equals(this.wrapupSkipped, mediaParticipantRequest.wrapupSkipped);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.wrapup, this.state, this.recording, this.muted, this.confined, this.held, this.wrapupSkipped});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaParticipantRequest {\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    recording: ").append(this.toIndentedString(this.recording)).append("\n");
        sb.append("    muted: ").append(this.toIndentedString(this.muted)).append("\n");
        sb.append("    confined: ").append(this.toIndentedString(this.confined)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    wrapupSkipped: ").append(this.toIndentedString(this.wrapupSkipped)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        PARKED("parked"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

