/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.IntegrationConfigurationInfo;
import com.mypurecloud.sdk.v2.model.IntegrationStatusInfo;
import com.mypurecloud.sdk.v2.model.IntegrationType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Details for an Integration")
public class Integration
implements Serializable {
    private String id = null;
    private String name = null;
    private IntegrationType integrationType = null;
    private String notes = null;
    private IntendedStateEnum intendedState = null;
    private IntegrationConfigurationInfo config = null;
    private IntegrationStatusInfo reportedState = null;
    private Map<String, String> attributes = null;
    private String selfUri = null;

    public Integration() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The name of the integration, used to distinguish this integration from others of the same type.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="Type of the integration")
    @JsonProperty(value="integrationType")
    public IntegrationType getIntegrationType() {
        return this.integrationType;
    }

    @ApiModelProperty(example="null", value="Notes about the integration.")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public Integration intendedState(IntendedStateEnum intendedState) {
        this.intendedState = intendedState;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Configured state of the integration.")
    @JsonProperty(value="intendedState")
    public IntendedStateEnum getIntendedState() {
        return this.intendedState;
    }

    public void setIntendedState(IntendedStateEnum intendedState) {
        this.intendedState = intendedState;
    }

    @ApiModelProperty(example="null", value="Configuration information for the integration.")
    @JsonProperty(value="config")
    public IntegrationConfigurationInfo getConfig() {
        return this.config;
    }

    @ApiModelProperty(example="null", value="Last reported status of the integration.")
    @JsonProperty(value="reportedState")
    public IntegrationStatusInfo getReportedState() {
        return this.reportedState;
    }

    @ApiModelProperty(example="null", value="Read-only attributes for the integration.")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Integration integration = (Integration)o;
        return Objects.equals(this.id, integration.id) && Objects.equals(this.name, integration.name) && Objects.equals(this.integrationType, integration.integrationType) && Objects.equals(this.notes, integration.notes) && Objects.equals((Object)this.intendedState, (Object)integration.intendedState) && Objects.equals(this.config, integration.config) && Objects.equals(this.reportedState, integration.reportedState) && Objects.equals(this.attributes, integration.attributes) && Objects.equals(this.selfUri, integration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.integrationType, this.notes, this.intendedState, this.config, this.reportedState, this.attributes, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Integration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    integrationType: ").append(this.toIndentedString(this.integrationType)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    intendedState: ").append(this.toIndentedString((Object)this.intendedState)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    reportedState: ").append(this.toIndentedString(this.reportedState)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=IntendedStateEnumDeserializer.class)
    public static enum IntendedStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENABLED("ENABLED"),
        DISABLED("DISABLED"),
        DELETED("DELETED"),
        RESTORED("RESTORED");

        private String value;

        private IntendedStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IntendedStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (IntendedStateEnum value : IntendedStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return IntendedStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class IntendedStateEnumDeserializer
    extends StdDeserializer<IntendedStateEnum> {
        public IntendedStateEnumDeserializer() {
            super(IntendedStateEnumDeserializer.class);
        }

        public IntendedStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return IntendedStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

