/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MessagingSettingRequestReference;
import com.mypurecloud.sdk.v2.model.SupportedContentReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class InstagramIntegrationRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private SupportedContentReference supportedContent = null;
    private MessagingSettingRequestReference messagingSetting = null;
    private String pageAccessToken = null;
    private String userAccessToken = null;
    private String pageId = null;
    private String appId = null;
    private String appSecret = null;
    private String selfUri = null;

    public InstagramIntegrationRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public InstagramIntegrationRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Instagram Integration")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InstagramIntegrationRequest supportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the SupportedContent profile configured for an integration")
    @JsonProperty(value="supportedContent")
    public SupportedContentReference getSupportedContent() {
        return this.supportedContent;
    }

    public void setSupportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
    }

    public InstagramIntegrationRequest messagingSetting(MessagingSettingRequestReference messagingSetting) {
        this.messagingSetting = messagingSetting;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the message settings to be applied for this integration")
    @JsonProperty(value="messagingSetting")
    public MessagingSettingRequestReference getMessagingSetting() {
        return this.messagingSetting;
    }

    public void setMessagingSetting(MessagingSettingRequestReference messagingSetting) {
        this.messagingSetting = messagingSetting;
    }

    public InstagramIntegrationRequest pageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
        return this;
    }

    @ApiModelProperty(example="null", value="The long-lived Page Access Token of Instagram page.  See https://developers.facebook.com/docs/facebook-login/access-tokens.  When a pageAccessToken is provided, pageId and userAccessToken are not required.")
    @JsonProperty(value="pageAccessToken")
    public String getPageAccessToken() {
        return this.pageAccessToken;
    }

    public void setPageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
    }

    public InstagramIntegrationRequest userAccessToken(String userAccessToken) {
        this.userAccessToken = userAccessToken;
        return this;
    }

    @ApiModelProperty(example="null", value="The short-lived User Access Token of Instagram user logged into Facebook app.  See https://developers.facebook.com/docs/facebook-login/access-tokens.  When userAccessToken is provided, pageId is mandatory.  When userAccessToken/pageId combination is provided, pageAccessToken is not required.")
    @JsonProperty(value="userAccessToken")
    public String getUserAccessToken() {
        return this.userAccessToken;
    }

    public void setUserAccessToken(String userAccessToken) {
        this.userAccessToken = userAccessToken;
    }

    public InstagramIntegrationRequest pageId(String pageId) {
        this.pageId = pageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The page ID of Instagram page. The pageId is required when userAccessToken is provided.")
    @JsonProperty(value="pageId")
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public InstagramIntegrationRequest appId(String appId) {
        this.appId = appId;
        return this;
    }

    @ApiModelProperty(example="null", value="The app ID of Facebook app. The appId is required when a customer wants to use their own approved Facebook app.")
    @JsonProperty(value="appId")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public InstagramIntegrationRequest appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    @ApiModelProperty(example="null", value="The app Secret of Facebook app. The appSecret is required when appId is provided.")
    @JsonProperty(value="appSecret")
    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstagramIntegrationRequest instagramIntegrationRequest = (InstagramIntegrationRequest)o;
        return Objects.equals(this.id, instagramIntegrationRequest.id) && Objects.equals(this.name, instagramIntegrationRequest.name) && Objects.equals(this.supportedContent, instagramIntegrationRequest.supportedContent) && Objects.equals(this.messagingSetting, instagramIntegrationRequest.messagingSetting) && Objects.equals(this.pageAccessToken, instagramIntegrationRequest.pageAccessToken) && Objects.equals(this.userAccessToken, instagramIntegrationRequest.userAccessToken) && Objects.equals(this.pageId, instagramIntegrationRequest.pageId) && Objects.equals(this.appId, instagramIntegrationRequest.appId) && Objects.equals(this.appSecret, instagramIntegrationRequest.appSecret) && Objects.equals(this.selfUri, instagramIntegrationRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.supportedContent, this.messagingSetting, this.pageAccessToken, this.userAccessToken, this.pageId, this.appId, this.appSecret, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstagramIntegrationRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    supportedContent: ").append(this.toIndentedString(this.supportedContent)).append("\n");
        sb.append("    messagingSetting: ").append(this.toIndentedString(this.messagingSetting)).append("\n");
        sb.append("    pageAccessToken: ").append(this.toIndentedString(this.pageAccessToken)).append("\n");
        sb.append("    userAccessToken: ").append(this.toIndentedString(this.userAccessToken)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    appSecret: ").append(this.toIndentedString(this.appSecret)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

