/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.HistoricalShrinkageActivityCodeResponse;
import com.mypurecloud.sdk.v2.model.HistoricalShrinkageAggregateResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HistoricalShrinkageActivityCategoryResponse
implements Serializable {
    private ActivityCategoryEnum activityCategory = null;
    private HistoricalShrinkageAggregateResponse shrinkageForActivityCategory = null;
    private List<HistoricalShrinkageActivityCodeResponse> shrinkageForActivityCodes = null;

    public HistoricalShrinkageActivityCategoryResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.shrinkageForActivityCodes = new ArrayList<HistoricalShrinkageActivityCodeResponse>();
        }
    }

    public HistoricalShrinkageActivityCategoryResponse activityCategory(ActivityCategoryEnum activityCategory) {
        this.activityCategory = activityCategory;
        return this;
    }

    @ApiModelProperty(example="null", value="Activity category for which shrinkage data is provided")
    @JsonProperty(value="activityCategory")
    public ActivityCategoryEnum getActivityCategory() {
        return this.activityCategory;
    }

    public void setActivityCategory(ActivityCategoryEnum activityCategory) {
        this.activityCategory = activityCategory;
    }

    public HistoricalShrinkageActivityCategoryResponse shrinkageForActivityCategory(HistoricalShrinkageAggregateResponse shrinkageForActivityCategory) {
        this.shrinkageForActivityCategory = shrinkageForActivityCategory;
        return this;
    }

    @ApiModelProperty(example="null", value="Aggregated shrinkage data for the activity category")
    @JsonProperty(value="shrinkageForActivityCategory")
    public HistoricalShrinkageAggregateResponse getShrinkageForActivityCategory() {
        return this.shrinkageForActivityCategory;
    }

    public void setShrinkageForActivityCategory(HistoricalShrinkageAggregateResponse shrinkageForActivityCategory) {
        this.shrinkageForActivityCategory = shrinkageForActivityCategory;
    }

    public HistoricalShrinkageActivityCategoryResponse shrinkageForActivityCodes(List<HistoricalShrinkageActivityCodeResponse> shrinkageForActivityCodes) {
        this.shrinkageForActivityCodes = shrinkageForActivityCodes;
        return this;
    }

    @ApiModelProperty(example="null", value="Shrinkage for the activity codes under this activity category")
    @JsonProperty(value="shrinkageForActivityCodes")
    public List<HistoricalShrinkageActivityCodeResponse> getShrinkageForActivityCodes() {
        return this.shrinkageForActivityCodes;
    }

    public void setShrinkageForActivityCodes(List<HistoricalShrinkageActivityCodeResponse> shrinkageForActivityCodes) {
        this.shrinkageForActivityCodes = shrinkageForActivityCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalShrinkageActivityCategoryResponse historicalShrinkageActivityCategoryResponse = (HistoricalShrinkageActivityCategoryResponse)o;
        return Objects.equals((Object)this.activityCategory, (Object)historicalShrinkageActivityCategoryResponse.activityCategory) && Objects.equals(this.shrinkageForActivityCategory, historicalShrinkageActivityCategoryResponse.shrinkageForActivityCategory) && Objects.equals(this.shrinkageForActivityCodes, historicalShrinkageActivityCategoryResponse.shrinkageForActivityCodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activityCategory, this.shrinkageForActivityCategory, this.shrinkageForActivityCodes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricalShrinkageActivityCategoryResponse {\n");
        sb.append("    activityCategory: ").append(this.toIndentedString((Object)this.activityCategory)).append("\n");
        sb.append("    shrinkageForActivityCategory: ").append(this.toIndentedString(this.shrinkageForActivityCategory)).append("\n");
        sb.append("    shrinkageForActivityCodes: ").append(this.toIndentedString(this.shrinkageForActivityCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActivityCategoryEnumDeserializer.class)
    public static enum ActivityCategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable"),
        UNSCHEDULED("Unscheduled");

        private String value;

        private ActivityCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivityCategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivityCategoryEnum value : ActivityCategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivityCategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActivityCategoryEnumDeserializer
    extends StdDeserializer<ActivityCategoryEnum> {
        public ActivityCategoryEnumDeserializer() {
            super(ActivityCategoryEnumDeserializer.class);
        }

        public ActivityCategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActivityCategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

