/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class HistoricalDataDisallowedDeleteEntity
implements Serializable {
    private String requestId = null;
    private ReasonEnum reason = null;

    public HistoricalDataDisallowedDeleteEntity() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public HistoricalDataDisallowedDeleteEntity requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(example="null", value="The requestId associated with this disallowed entity")
    @JsonProperty(value="requestId")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public HistoricalDataDisallowedDeleteEntity reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(example="null", value="The error code explaining why the delete request for the requestId was disallowed")
    @JsonProperty(value="reason")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalDataDisallowedDeleteEntity historicalDataDisallowedDeleteEntity = (HistoricalDataDisallowedDeleteEntity)o;
        return Objects.equals(this.requestId, historicalDataDisallowedDeleteEntity.requestId) && Objects.equals((Object)this.reason, (Object)historicalDataDisallowedDeleteEntity.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestId, this.reason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricalDataDisallowedDeleteEntity {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ReasonEnumDeserializer.class)
    public static enum ReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INVALIDREQUEST("InvalidRequest"),
        VALIDATIONINPROGRESS("ValidationInProgress"),
        DELETEINPROGRESS("DeleteInProgress"),
        REQUESTIDNOTFOUND("RequestIdNotFound");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReasonEnum value : ReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ReasonEnumDeserializer
    extends StdDeserializer<ReasonEnum> {
        public ReasonEnumDeserializer() {
            super(ReasonEnumDeserializer.class);
        }

        public ReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

