/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="JSON schema that defines the transformed result that will be sent back to the caller. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned.")
public class FlattenedJsonSchemaDocument
implements Serializable {
    private JsonSchemaDocument schema = null;
    private List<String> arrayProperties = null;

    public FlattenedJsonSchemaDocument() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.arrayProperties = new ArrayList<String>();
        }
    }

    public FlattenedJsonSchemaDocument schema(JsonSchemaDocument schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="schema")
    public JsonSchemaDocument getSchema() {
        return this.schema;
    }

    public void setSchema(JsonSchemaDocument schema) {
        this.schema = schema;
    }

    public FlattenedJsonSchemaDocument arrayProperties(List<String> arrayProperties) {
        this.arrayProperties = arrayProperties;
        return this;
    }

    @ApiModelProperty(example="null", value="Properties in the original document that were arrays")
    @JsonProperty(value="arrayProperties")
    public List<String> getArrayProperties() {
        return this.arrayProperties;
    }

    public void setArrayProperties(List<String> arrayProperties) {
        this.arrayProperties = arrayProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlattenedJsonSchemaDocument flattenedJsonSchemaDocument = (FlattenedJsonSchemaDocument)o;
        return Objects.equals(this.schema, flattenedJsonSchemaDocument.schema) && Objects.equals(this.arrayProperties, flattenedJsonSchemaDocument.arrayProperties);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.arrayProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlattenedJsonSchemaDocument {\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    arrayProperties: ").append(this.toIndentedString(this.arrayProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

