/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.EstimateAvailableFullDayTimeOffResponse;
import com.mypurecloud.sdk.v2.model.EstimateAvailablePartialDayTimeOffResponse;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EstimateAvailableTimeOffResponse
implements Serializable {
    private List<EstimateAvailableFullDayTimeOffResponse> fullDayDates = null;
    private List<EstimateAvailablePartialDayTimeOffResponse> partialDayDates = null;
    private UserReference user = null;
    private String activityCodeId = null;
    private Boolean paid = null;

    public EstimateAvailableTimeOffResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.fullDayDates = new ArrayList<EstimateAvailableFullDayTimeOffResponse>();
            this.partialDayDates = new ArrayList<EstimateAvailablePartialDayTimeOffResponse>();
        }
    }

    public EstimateAvailableTimeOffResponse fullDayDates(List<EstimateAvailableFullDayTimeOffResponse> fullDayDates) {
        this.fullDayDates = fullDayDates;
        return this;
    }

    @ApiModelProperty(example="null", value="Full day dates. partialDayDates must be empty if this field is populated")
    @JsonProperty(value="fullDayDates")
    public List<EstimateAvailableFullDayTimeOffResponse> getFullDayDates() {
        return this.fullDayDates;
    }

    public void setFullDayDates(List<EstimateAvailableFullDayTimeOffResponse> fullDayDates) {
        this.fullDayDates = fullDayDates;
    }

    public EstimateAvailableTimeOffResponse partialDayDates(List<EstimateAvailablePartialDayTimeOffResponse> partialDayDates) {
        this.partialDayDates = partialDayDates;
        return this;
    }

    @ApiModelProperty(example="null", value="Partial day dates. fullDayDates must be empty if this field is populated")
    @JsonProperty(value="partialDayDates")
    public List<EstimateAvailablePartialDayTimeOffResponse> getPartialDayDates() {
        return this.partialDayDates;
    }

    public void setPartialDayDates(List<EstimateAvailablePartialDayTimeOffResponse> partialDayDates) {
        this.partialDayDates = partialDayDates;
    }

    public EstimateAvailableTimeOffResponse user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user to whom the time off request belongs")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public EstimateAvailableTimeOffResponse activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the activity code associated with the time off request. Activity code must be of the TimeOff category")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public EstimateAvailableTimeOffResponse paid(Boolean paid) {
        this.paid = paid;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether this estimate is for a paid time off request")
    @JsonProperty(value="paid")
    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EstimateAvailableTimeOffResponse estimateAvailableTimeOffResponse = (EstimateAvailableTimeOffResponse)o;
        return Objects.equals(this.fullDayDates, estimateAvailableTimeOffResponse.fullDayDates) && Objects.equals(this.partialDayDates, estimateAvailableTimeOffResponse.partialDayDates) && Objects.equals(this.user, estimateAvailableTimeOffResponse.user) && Objects.equals(this.activityCodeId, estimateAvailableTimeOffResponse.activityCodeId) && Objects.equals(this.paid, estimateAvailableTimeOffResponse.paid);
    }

    public int hashCode() {
        return Objects.hash(this.fullDayDates, this.partialDayDates, this.user, this.activityCodeId, this.paid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EstimateAvailableTimeOffResponse {\n");
        sb.append("    fullDayDates: ").append(this.toIndentedString(this.fullDayDates)).append("\n");
        sb.append("    partialDayDates: ").append(this.toIndentedString(this.partialDayDates)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    paid: ").append(this.toIndentedString(this.paid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

