/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DecisionTableRowParameterValue;
import com.mypurecloud.sdk.v2.model.DecisionTableVersionEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class DecisionTableRow
implements Serializable {
    private String id = null;
    private DecisionTableVersionEntity table = null;
    private Integer rowIndex = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Map<String, DecisionTableRowParameterValue> inputs = null;
    private Map<String, DecisionTableRowParameterValue> outputs = null;
    private String selfUri = null;

    public DecisionTableRow() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DecisionTableRow table(DecisionTableVersionEntity table) {
        this.table = table;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The decision table to which this row belongs")
    @JsonProperty(value="table")
    public DecisionTableVersionEntity getTable() {
        return this.table;
    }

    public void setTable(DecisionTableVersionEntity table) {
        this.table = table;
    }

    public DecisionTableRow rowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
        return this;
    }

    @ApiModelProperty(example="null", value="The absolute index of this row in the decision table, starting at 1")
    @JsonProperty(value="rowIndex")
    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public DecisionTableRow dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The date when this row was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public DecisionTableRow dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The date when this row was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public DecisionTableRow inputs(Map<String, DecisionTableRowParameterValue> inputs) {
        this.inputs = inputs;
        return this;
    }

    @ApiModelProperty(example="null", value="The map input values of the row being created. At least one value must be provided. The key for this map is the column ID the row value relates")
    @JsonProperty(value="inputs")
    public Map<String, DecisionTableRowParameterValue> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, DecisionTableRowParameterValue> inputs) {
        this.inputs = inputs;
    }

    public DecisionTableRow outputs(Map<String, DecisionTableRowParameterValue> outputs) {
        this.outputs = outputs;
        return this;
    }

    @ApiModelProperty(example="null", value="The map output values of the row being created. At least one value must be provided. The key for this map is the column ID the row value relates")
    @JsonProperty(value="outputs")
    public Map<String, DecisionTableRowParameterValue> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Map<String, DecisionTableRowParameterValue> outputs) {
        this.outputs = outputs;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionTableRow decisionTableRow = (DecisionTableRow)o;
        return Objects.equals(this.id, decisionTableRow.id) && Objects.equals(this.table, decisionTableRow.table) && Objects.equals(this.rowIndex, decisionTableRow.rowIndex) && Objects.equals(this.dateCreated, decisionTableRow.dateCreated) && Objects.equals(this.dateModified, decisionTableRow.dateModified) && Objects.equals(this.inputs, decisionTableRow.inputs) && Objects.equals(this.outputs, decisionTableRow.outputs) && Objects.equals(this.selfUri, decisionTableRow.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.table, this.rowIndex, this.dateCreated, this.dateModified, this.inputs, this.outputs, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionTableRow {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    table: ").append(this.toIndentedString(this.table)).append("\n");
        sb.append("    rowIndex: ").append(this.toIndentedString(this.rowIndex)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

